package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.CertificateId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeCaCertificateRequest(certificateId: CertificateId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeCaCertificateRequest = {
    import DescribeCaCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeCaCertificateRequest
      .builder()
      .certificateId(CertificateId.unwrap(certificateId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeCaCertificateRequest.ReadOnly =
    zio.aws.iot.model.DescribeCaCertificateRequest.wrap(buildAwsValue())
}
object DescribeCaCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeCaCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeCaCertificateRequest =
      zio.aws.iot.model.DescribeCaCertificateRequest(certificateId)
    def certificateId: CertificateId
    def getCertificateId: ZIO[Any, Nothing, CertificateId] =
      ZIO.succeed(certificateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeCaCertificateRequest
  ) extends zio.aws.iot.model.DescribeCaCertificateRequest.ReadOnly {
    override val certificateId: CertificateId =
      zio.aws.iot.model.primitives.CertificateId(impl.certificateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeCaCertificateRequest
  ): zio.aws.iot.model.DescribeCaCertificateRequest.ReadOnly = new Wrapper(impl)
}
