package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.MetricName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeCustomMetricRequest(metricName: MetricName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeCustomMetricRequest = {
    import DescribeCustomMetricRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeCustomMetricRequest
      .builder()
      .metricName(MetricName.unwrap(metricName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeCustomMetricRequest.ReadOnly =
    zio.aws.iot.model.DescribeCustomMetricRequest.wrap(buildAwsValue())
}
object DescribeCustomMetricRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeCustomMetricRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeCustomMetricRequest =
      zio.aws.iot.model.DescribeCustomMetricRequest(metricName)
    def metricName: MetricName
    def getMetricName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(metricName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeCustomMetricRequest
  ) extends zio.aws.iot.model.DescribeCustomMetricRequest.ReadOnly {
    override val metricName: MetricName =
      zio.aws.iot.model.primitives.MetricName(impl.metricName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeCustomMetricRequest
  ): zio.aws.iot.model.DescribeCustomMetricRequest.ReadOnly = new Wrapper(impl)
}
