package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.MitigationActionsTaskId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeDetectMitigationActionsTaskRequest(
    taskId: MitigationActionsTaskId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeDetectMitigationActionsTaskRequest = {
    import DescribeDetectMitigationActionsTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeDetectMitigationActionsTaskRequest
      .builder()
      .taskId(MitigationActionsTaskId.unwrap(taskId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DescribeDetectMitigationActionsTaskRequest.ReadOnly =
    zio.aws.iot.model.DescribeDetectMitigationActionsTaskRequest
      .wrap(buildAwsValue())
}
object DescribeDetectMitigationActionsTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeDetectMitigationActionsTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot.model.DescribeDetectMitigationActionsTaskRequest =
      zio.aws.iot.model.DescribeDetectMitigationActionsTaskRequest(taskId)
    def taskId: MitigationActionsTaskId
    def getTaskId: ZIO[Any, Nothing, MitigationActionsTaskId] =
      ZIO.succeed(taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeDetectMitigationActionsTaskRequest
  ) extends zio.aws.iot.model.DescribeDetectMitigationActionsTaskRequest.ReadOnly {
    override val taskId: MitigationActionsTaskId =
      zio.aws.iot.model.primitives.MitigationActionsTaskId(impl.taskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeDetectMitigationActionsTaskRequest
  ): zio.aws.iot.model.DescribeDetectMitigationActionsTaskRequest.ReadOnly =
    new Wrapper(impl)
}
