package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDetectMitigationActionsTaskResponse(
    taskSummary: Optional[
      zio.aws.iot.model.DetectMitigationActionsTaskSummary
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeDetectMitigationActionsTaskResponse = {
    import DescribeDetectMitigationActionsTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeDetectMitigationActionsTaskResponse
      .builder()
      .optionallyWith(taskSummary.map(value => value.buildAwsValue()))(
        _.taskSummary
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DescribeDetectMitigationActionsTaskResponse.ReadOnly =
    zio.aws.iot.model.DescribeDetectMitigationActionsTaskResponse
      .wrap(buildAwsValue())
}
object DescribeDetectMitigationActionsTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeDetectMitigationActionsTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot.model.DescribeDetectMitigationActionsTaskResponse =
      zio.aws.iot.model.DescribeDetectMitigationActionsTaskResponse(
        taskSummary.map(value => value.asEditable)
      )
    def taskSummary: Optional[
      zio.aws.iot.model.DetectMitigationActionsTaskSummary.ReadOnly
    ]
    def getTaskSummary: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.DetectMitigationActionsTaskSummary.ReadOnly
    ] = AwsError.unwrapOptionField("taskSummary", taskSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeDetectMitigationActionsTaskResponse
  ) extends zio.aws.iot.model.DescribeDetectMitigationActionsTaskResponse.ReadOnly {
    override val taskSummary: Optional[
      zio.aws.iot.model.DetectMitigationActionsTaskSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.taskSummary())
      .map(value =>
        zio.aws.iot.model.DetectMitigationActionsTaskSummary.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeDetectMitigationActionsTaskResponse
  ): zio.aws.iot.model.DescribeDetectMitigationActionsTaskResponse.ReadOnly =
    new Wrapper(impl)
}
