package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.ReservedDomainConfigurationName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeDomainConfigurationRequest(
    domainConfigurationName: ReservedDomainConfigurationName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeDomainConfigurationRequest = {
    import DescribeDomainConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeDomainConfigurationRequest
      .builder()
      .domainConfigurationName(
        ReservedDomainConfigurationName.unwrap(
          domainConfigurationName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DescribeDomainConfigurationRequest.ReadOnly =
    zio.aws.iot.model.DescribeDomainConfigurationRequest.wrap(buildAwsValue())
}
object DescribeDomainConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeDomainConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeDomainConfigurationRequest =
      zio.aws.iot.model
        .DescribeDomainConfigurationRequest(domainConfigurationName)
    def domainConfigurationName: ReservedDomainConfigurationName
    def getDomainConfigurationName
        : ZIO[Any, Nothing, ReservedDomainConfigurationName] =
      ZIO.succeed(domainConfigurationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeDomainConfigurationRequest
  ) extends zio.aws.iot.model.DescribeDomainConfigurationRequest.ReadOnly {
    override val domainConfigurationName: ReservedDomainConfigurationName =
      zio.aws.iot.model.primitives
        .ReservedDomainConfigurationName(impl.domainConfigurationName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeDomainConfigurationRequest
  ): zio.aws.iot.model.DescribeDomainConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
