package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{LastModifiedDate, CreationDate}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeEventConfigurationsResponse(
    eventConfigurations: Optional[
      Map[zio.aws.iot.model.EventType, zio.aws.iot.model.Configuration]
    ] = Optional.Absent,
    creationDate: Optional[CreationDate] = Optional.Absent,
    lastModifiedDate: Optional[LastModifiedDate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeEventConfigurationsResponse = {
    import DescribeEventConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeEventConfigurationsResponse
      .builder()
      .optionallyWith(
        eventConfigurations.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.eventConfigurationsWithStrings)
      .optionallyWith(
        creationDate.map(value => CreationDate.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => LastModifiedDate.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DescribeEventConfigurationsResponse.ReadOnly =
    zio.aws.iot.model.DescribeEventConfigurationsResponse.wrap(buildAwsValue())
}
object DescribeEventConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeEventConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeEventConfigurationsResponse =
      zio.aws.iot.model.DescribeEventConfigurationsResponse(
        eventConfigurations.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value)
      )
    def eventConfigurations: Optional[
      Map[zio.aws.iot.model.EventType, zio.aws.iot.model.Configuration.ReadOnly]
    ]
    def creationDate: Optional[CreationDate]
    def lastModifiedDate: Optional[LastModifiedDate]
    def getEventConfigurations: ZIO[Any, AwsError, Map[
      zio.aws.iot.model.EventType,
      zio.aws.iot.model.Configuration.ReadOnly
    ]] = AwsError.unwrapOptionField("eventConfigurations", eventConfigurations)
    def getCreationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, LastModifiedDate] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeEventConfigurationsResponse
  ) extends zio.aws.iot.model.DescribeEventConfigurationsResponse.ReadOnly {
    override val eventConfigurations: Optional[
      Map[zio.aws.iot.model.EventType, zio.aws.iot.model.Configuration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.eventConfigurations())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.EventType
              .wrap(key) -> zio.aws.iot.model.Configuration.wrap(value)
          })
          .toMap
      )
    override val creationDate: Optional[CreationDate] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.CreationDate(value))
    override val lastModifiedDate: Optional[LastModifiedDate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedDate())
        .map(value => zio.aws.iot.model.primitives.LastModifiedDate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeEventConfigurationsResponse
  ): zio.aws.iot.model.DescribeEventConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
