package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  IndexName,
  AggregationField,
  FleetMetricPeriod,
  FleetMetricDescription,
  FleetMetricName,
  Version,
  QueryVersion,
  QueryString,
  LastModifiedDate,
  FleetMetricArn,
  CreationDate
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeFleetMetricResponse(
    metricName: Optional[FleetMetricName] = Optional.Absent,
    queryString: Optional[QueryString] = Optional.Absent,
    aggregationType: Optional[zio.aws.iot.model.AggregationType] =
      Optional.Absent,
    period: Optional[FleetMetricPeriod] = Optional.Absent,
    aggregationField: Optional[AggregationField] = Optional.Absent,
    description: Optional[FleetMetricDescription] = Optional.Absent,
    queryVersion: Optional[QueryVersion] = Optional.Absent,
    indexName: Optional[IndexName] = Optional.Absent,
    creationDate: Optional[CreationDate] = Optional.Absent,
    lastModifiedDate: Optional[LastModifiedDate] = Optional.Absent,
    unit: Optional[zio.aws.iot.model.FleetMetricUnit] = Optional.Absent,
    version: Optional[Version] = Optional.Absent,
    metricArn: Optional[FleetMetricArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeFleetMetricResponse = {
    import DescribeFleetMetricResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeFleetMetricResponse
      .builder()
      .optionallyWith(
        metricName.map(value => FleetMetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        queryString.map(value => QueryString.unwrap(value): java.lang.String)
      )(_.queryString)
      .optionallyWith(aggregationType.map(value => value.buildAwsValue()))(
        _.aggregationType
      )
      .optionallyWith(
        period.map(value => FleetMetricPeriod.unwrap(value): Integer)
      )(_.period)
      .optionallyWith(
        aggregationField.map(value =>
          AggregationField.unwrap(value): java.lang.String
        )
      )(_.aggregationField)
      .optionallyWith(
        description.map(value =>
          FleetMetricDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        queryVersion.map(value => QueryVersion.unwrap(value): java.lang.String)
      )(_.queryVersion)
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(
        creationDate.map(value => CreationDate.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => LastModifiedDate.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .optionallyWith(
        version.map(value => Version.unwrap(value): java.lang.Long)
      )(_.version)
      .optionallyWith(
        metricArn.map(value => FleetMetricArn.unwrap(value): java.lang.String)
      )(_.metricArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeFleetMetricResponse.ReadOnly =
    zio.aws.iot.model.DescribeFleetMetricResponse.wrap(buildAwsValue())
}
object DescribeFleetMetricResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeFleetMetricResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeFleetMetricResponse =
      zio.aws.iot.model.DescribeFleetMetricResponse(
        metricName.map(value => value),
        queryString.map(value => value),
        aggregationType.map(value => value.asEditable),
        period.map(value => value),
        aggregationField.map(value => value),
        description.map(value => value),
        queryVersion.map(value => value),
        indexName.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value),
        unit.map(value => value),
        version.map(value => value),
        metricArn.map(value => value)
      )
    def metricName: Optional[FleetMetricName]
    def queryString: Optional[QueryString]
    def aggregationType: Optional[zio.aws.iot.model.AggregationType.ReadOnly]
    def period: Optional[FleetMetricPeriod]
    def aggregationField: Optional[AggregationField]
    def description: Optional[FleetMetricDescription]
    def queryVersion: Optional[QueryVersion]
    def indexName: Optional[IndexName]
    def creationDate: Optional[CreationDate]
    def lastModifiedDate: Optional[LastModifiedDate]
    def unit: Optional[zio.aws.iot.model.FleetMetricUnit]
    def version: Optional[Version]
    def metricArn: Optional[FleetMetricArn]
    def getMetricName: ZIO[Any, AwsError, FleetMetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getQueryString: ZIO[Any, AwsError, QueryString] =
      AwsError.unwrapOptionField("queryString", queryString)
    def getAggregationType
        : ZIO[Any, AwsError, zio.aws.iot.model.AggregationType.ReadOnly] =
      AwsError.unwrapOptionField("aggregationType", aggregationType)
    def getPeriod: ZIO[Any, AwsError, FleetMetricPeriod] =
      AwsError.unwrapOptionField("period", period)
    def getAggregationField: ZIO[Any, AwsError, AggregationField] =
      AwsError.unwrapOptionField("aggregationField", aggregationField)
    def getDescription: ZIO[Any, AwsError, FleetMetricDescription] =
      AwsError.unwrapOptionField("description", description)
    def getQueryVersion: ZIO[Any, AwsError, QueryVersion] =
      AwsError.unwrapOptionField("queryVersion", queryVersion)
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getCreationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, LastModifiedDate] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getUnit: ZIO[Any, AwsError, zio.aws.iot.model.FleetMetricUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("version", version)
    def getMetricArn: ZIO[Any, AwsError, FleetMetricArn] =
      AwsError.unwrapOptionField("metricArn", metricArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeFleetMetricResponse
  ) extends zio.aws.iot.model.DescribeFleetMetricResponse.ReadOnly {
    override val metricName: Optional[FleetMetricName] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value => zio.aws.iot.model.primitives.FleetMetricName(value))
    override val queryString: Optional[QueryString] = zio.aws.core.internal
      .optionalFromNullable(impl.queryString())
      .map(value => zio.aws.iot.model.primitives.QueryString(value))
    override val aggregationType
        : Optional[zio.aws.iot.model.AggregationType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregationType())
        .map(value => zio.aws.iot.model.AggregationType.wrap(value))
    override val period: Optional[FleetMetricPeriod] = zio.aws.core.internal
      .optionalFromNullable(impl.period())
      .map(value => zio.aws.iot.model.primitives.FleetMetricPeriod(value))
    override val aggregationField: Optional[AggregationField] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregationField())
        .map(value => zio.aws.iot.model.primitives.AggregationField(value))
    override val description: Optional[FleetMetricDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.iot.model.primitives.FleetMetricDescription(value)
        )
    override val queryVersion: Optional[QueryVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.queryVersion())
      .map(value => zio.aws.iot.model.primitives.QueryVersion(value))
    override val indexName: Optional[IndexName] = zio.aws.core.internal
      .optionalFromNullable(impl.indexName())
      .map(value => zio.aws.iot.model.primitives.IndexName(value))
    override val creationDate: Optional[CreationDate] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.CreationDate(value))
    override val lastModifiedDate: Optional[LastModifiedDate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedDate())
        .map(value => zio.aws.iot.model.primitives.LastModifiedDate(value))
    override val unit: Optional[zio.aws.iot.model.FleetMetricUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value => zio.aws.iot.model.FleetMetricUnit.wrap(value))
    override val version: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.iot.model.primitives.Version(value))
    override val metricArn: Optional[FleetMetricArn] = zio.aws.core.internal
      .optionalFromNullable(impl.metricArn())
      .map(value => zio.aws.iot.model.primitives.FleetMetricArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeFleetMetricResponse
  ): zio.aws.iot.model.DescribeFleetMetricResponse.ReadOnly = new Wrapper(impl)
}
