package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.JobDocumentSource
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeJobResponse(
    documentSource: Optional[JobDocumentSource] = Optional.Absent,
    job: Optional[zio.aws.iot.model.Job] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeJobResponse = {
    import DescribeJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeJobResponse
      .builder()
      .optionallyWith(
        documentSource.map(value =>
          JobDocumentSource.unwrap(value): java.lang.String
        )
      )(_.documentSource)
      .optionallyWith(job.map(value => value.buildAwsValue()))(_.job)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeJobResponse.ReadOnly =
    zio.aws.iot.model.DescribeJobResponse.wrap(buildAwsValue())
}
object DescribeJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeJobResponse =
      zio.aws.iot.model.DescribeJobResponse(
        documentSource.map(value => value),
        job.map(value => value.asEditable)
      )
    def documentSource: Optional[JobDocumentSource]
    def job: Optional[zio.aws.iot.model.Job.ReadOnly]
    def getDocumentSource: ZIO[Any, AwsError, JobDocumentSource] =
      AwsError.unwrapOptionField("documentSource", documentSource)
    def getJob: ZIO[Any, AwsError, zio.aws.iot.model.Job.ReadOnly] =
      AwsError.unwrapOptionField("job", job)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeJobResponse
  ) extends zio.aws.iot.model.DescribeJobResponse.ReadOnly {
    override val documentSource: Optional[JobDocumentSource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentSource())
        .map(value => zio.aws.iot.model.primitives.JobDocumentSource(value))
    override val job: Optional[zio.aws.iot.model.Job.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.job())
        .map(value => zio.aws.iot.model.Job.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeJobResponse
  ): zio.aws.iot.model.DescribeJobResponse.ReadOnly = new Wrapper(impl)
}
