package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  JobTemplateArn,
  JobDocument,
  ManagedJobTemplateName,
  Environment,
  JobDescription,
  ManagedTemplateVersion
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeManagedJobTemplateResponse(
    templateName: Optional[ManagedJobTemplateName] = Optional.Absent,
    templateArn: Optional[JobTemplateArn] = Optional.Absent,
    description: Optional[JobDescription] = Optional.Absent,
    templateVersion: Optional[ManagedTemplateVersion] = Optional.Absent,
    environments: Optional[Iterable[Environment]] = Optional.Absent,
    documentParameters: Optional[
      Iterable[zio.aws.iot.model.DocumentParameter]
    ] = Optional.Absent,
    document: Optional[JobDocument] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeManagedJobTemplateResponse = {
    import DescribeManagedJobTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeManagedJobTemplateResponse
      .builder()
      .optionallyWith(
        templateName.map(value =>
          ManagedJobTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        templateArn.map(value => JobTemplateArn.unwrap(value): java.lang.String)
      )(_.templateArn)
      .optionallyWith(
        description.map(value => JobDescription.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        templateVersion.map(value =>
          ManagedTemplateVersion.unwrap(value): java.lang.String
        )
      )(_.templateVersion)
      .optionallyWith(
        environments.map(value =>
          value.map { item =>
            Environment.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.environments)
      .optionallyWith(
        documentParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentParameters)
      .optionallyWith(
        document.map(value => JobDocument.unwrap(value): java.lang.String)
      )(_.document)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DescribeManagedJobTemplateResponse.ReadOnly =
    zio.aws.iot.model.DescribeManagedJobTemplateResponse.wrap(buildAwsValue())
}
object DescribeManagedJobTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeManagedJobTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeManagedJobTemplateResponse =
      zio.aws.iot.model.DescribeManagedJobTemplateResponse(
        templateName.map(value => value),
        templateArn.map(value => value),
        description.map(value => value),
        templateVersion.map(value => value),
        environments.map(value => value),
        documentParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        document.map(value => value)
      )
    def templateName: Optional[ManagedJobTemplateName]
    def templateArn: Optional[JobTemplateArn]
    def description: Optional[JobDescription]
    def templateVersion: Optional[ManagedTemplateVersion]
    def environments: Optional[List[Environment]]
    def documentParameters
        : Optional[List[zio.aws.iot.model.DocumentParameter.ReadOnly]]
    def document: Optional[JobDocument]
    def getTemplateName: ZIO[Any, AwsError, ManagedJobTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getTemplateArn: ZIO[Any, AwsError, JobTemplateArn] =
      AwsError.unwrapOptionField("templateArn", templateArn)
    def getDescription: ZIO[Any, AwsError, JobDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTemplateVersion: ZIO[Any, AwsError, ManagedTemplateVersion] =
      AwsError.unwrapOptionField("templateVersion", templateVersion)
    def getEnvironments: ZIO[Any, AwsError, List[Environment]] =
      AwsError.unwrapOptionField("environments", environments)
    def getDocumentParameters: ZIO[Any, AwsError, List[
      zio.aws.iot.model.DocumentParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("documentParameters", documentParameters)
    def getDocument: ZIO[Any, AwsError, JobDocument] =
      AwsError.unwrapOptionField("document", document)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeManagedJobTemplateResponse
  ) extends zio.aws.iot.model.DescribeManagedJobTemplateResponse.ReadOnly {
    override val templateName: Optional[ManagedJobTemplateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateName())
        .map(value =>
          zio.aws.iot.model.primitives.ManagedJobTemplateName(value)
        )
    override val templateArn: Optional[JobTemplateArn] = zio.aws.core.internal
      .optionalFromNullable(impl.templateArn())
      .map(value => zio.aws.iot.model.primitives.JobTemplateArn(value))
    override val description: Optional[JobDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iot.model.primitives.JobDescription(value))
    override val templateVersion: Optional[ManagedTemplateVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateVersion())
        .map(value =>
          zio.aws.iot.model.primitives.ManagedTemplateVersion(value)
        )
    override val environments: Optional[List[Environment]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.primitives.Environment(item)
          }.toList
        )
    override val documentParameters
        : Optional[List[zio.aws.iot.model.DocumentParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.DocumentParameter.wrap(item)
          }.toList
        )
    override val document: Optional[JobDocument] = zio.aws.core.internal
      .optionalFromNullable(impl.document())
      .map(value => zio.aws.iot.model.primitives.JobDocument(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeManagedJobTemplateResponse
  ): zio.aws.iot.model.DescribeManagedJobTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
