package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.MitigationActionName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeMitigationActionRequest(
    actionName: MitigationActionName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeMitigationActionRequest = {
    import DescribeMitigationActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeMitigationActionRequest
      .builder()
      .actionName(MitigationActionName.unwrap(actionName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeMitigationActionRequest.ReadOnly =
    zio.aws.iot.model.DescribeMitigationActionRequest.wrap(buildAwsValue())
}
object DescribeMitigationActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeMitigationActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeMitigationActionRequest =
      zio.aws.iot.model.DescribeMitigationActionRequest(actionName)
    def actionName: MitigationActionName
    def getActionName: ZIO[Any, Nothing, MitigationActionName] =
      ZIO.succeed(actionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeMitigationActionRequest
  ) extends zio.aws.iot.model.DescribeMitigationActionRequest.ReadOnly {
    override val actionName: MitigationActionName =
      zio.aws.iot.model.primitives.MitigationActionName(impl.actionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeMitigationActionRequest
  ): zio.aws.iot.model.DescribeMitigationActionRequest.ReadOnly = new Wrapper(
    impl
  )
}
