package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{TemplateVersionId, TemplateName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeProvisioningTemplateVersionRequest(
    templateName: TemplateName,
    versionId: TemplateVersionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionRequest = {
    import DescribeProvisioningTemplateVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionRequest
      .builder()
      .templateName(TemplateName.unwrap(templateName): java.lang.String)
      .versionId(TemplateVersionId.unwrap(versionId): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DescribeProvisioningTemplateVersionRequest.ReadOnly =
    zio.aws.iot.model.DescribeProvisioningTemplateVersionRequest
      .wrap(buildAwsValue())
}
object DescribeProvisioningTemplateVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot.model.DescribeProvisioningTemplateVersionRequest =
      zio.aws.iot.model
        .DescribeProvisioningTemplateVersionRequest(templateName, versionId)
    def templateName: TemplateName
    def versionId: TemplateVersionId
    def getTemplateName: ZIO[Any, Nothing, TemplateName] =
      ZIO.succeed(templateName)
    def getVersionId: ZIO[Any, Nothing, TemplateVersionId] =
      ZIO.succeed(versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionRequest
  ) extends zio.aws.iot.model.DescribeProvisioningTemplateVersionRequest.ReadOnly {
    override val templateName: TemplateName =
      zio.aws.iot.model.primitives.TemplateName(impl.templateName())
    override val versionId: TemplateVersionId =
      zio.aws.iot.model.primitives.TemplateVersionId(impl.versionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionRequest
  ): zio.aws.iot.model.DescribeProvisioningTemplateVersionRequest.ReadOnly =
    new Wrapper(impl)
}
