package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.RoleAlias
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeRoleAliasRequest(roleAlias: RoleAlias) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeRoleAliasRequest = {
    import DescribeRoleAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeRoleAliasRequest
      .builder()
      .roleAlias(RoleAlias.unwrap(roleAlias): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeRoleAliasRequest.ReadOnly =
    zio.aws.iot.model.DescribeRoleAliasRequest.wrap(buildAwsValue())
}
object DescribeRoleAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeRoleAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeRoleAliasRequest =
      zio.aws.iot.model.DescribeRoleAliasRequest(roleAlias)
    def roleAlias: RoleAlias
    def getRoleAlias: ZIO[Any, Nothing, RoleAlias] = ZIO.succeed(roleAlias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeRoleAliasRequest
  ) extends zio.aws.iot.model.DescribeRoleAliasRequest.ReadOnly {
    override val roleAlias: RoleAlias =
      zio.aws.iot.model.primitives.RoleAlias(impl.roleAlias())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeRoleAliasRequest
  ): zio.aws.iot.model.DescribeRoleAliasRequest.ReadOnly = new Wrapper(impl)
}
