package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.ScheduledAuditName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeScheduledAuditRequest(
    scheduledAuditName: ScheduledAuditName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeScheduledAuditRequest = {
    import DescribeScheduledAuditRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeScheduledAuditRequest
      .builder()
      .scheduledAuditName(
        ScheduledAuditName.unwrap(scheduledAuditName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeScheduledAuditRequest.ReadOnly =
    zio.aws.iot.model.DescribeScheduledAuditRequest.wrap(buildAwsValue())
}
object DescribeScheduledAuditRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeScheduledAuditRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeScheduledAuditRequest =
      zio.aws.iot.model.DescribeScheduledAuditRequest(scheduledAuditName)
    def scheduledAuditName: ScheduledAuditName
    def getScheduledAuditName: ZIO[Any, Nothing, ScheduledAuditName] =
      ZIO.succeed(scheduledAuditName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeScheduledAuditRequest
  ) extends zio.aws.iot.model.DescribeScheduledAuditRequest.ReadOnly {
    override val scheduledAuditName: ScheduledAuditName =
      zio.aws.iot.model.primitives.ScheduledAuditName(impl.scheduledAuditName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeScheduledAuditRequest
  ): zio.aws.iot.model.DescribeScheduledAuditRequest.ReadOnly = new Wrapper(
    impl
  )
}
