package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.SecurityProfileName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeSecurityProfileRequest(
    securityProfileName: SecurityProfileName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeSecurityProfileRequest = {
    import DescribeSecurityProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeSecurityProfileRequest
      .builder()
      .securityProfileName(
        SecurityProfileName.unwrap(securityProfileName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeSecurityProfileRequest.ReadOnly =
    zio.aws.iot.model.DescribeSecurityProfileRequest.wrap(buildAwsValue())
}
object DescribeSecurityProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeSecurityProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeSecurityProfileRequest =
      zio.aws.iot.model.DescribeSecurityProfileRequest(securityProfileName)
    def securityProfileName: SecurityProfileName
    def getSecurityProfileName: ZIO[Any, Nothing, SecurityProfileName] =
      ZIO.succeed(securityProfileName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeSecurityProfileRequest
  ) extends zio.aws.iot.model.DescribeSecurityProfileRequest.ReadOnly {
    override val securityProfileName: SecurityProfileName =
      zio.aws.iot.model.primitives
        .SecurityProfileName(impl.securityProfileName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeSecurityProfileRequest
  ): zio.aws.iot.model.DescribeSecurityProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
