package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  SecurityProfileDescription,
  Timestamp,
  SecurityProfileArn,
  SecurityProfileName,
  Version,
  BehaviorMetric
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeSecurityProfileResponse(
    securityProfileName: Optional[SecurityProfileName] = Optional.Absent,
    securityProfileArn: Optional[SecurityProfileArn] = Optional.Absent,
    securityProfileDescription: Optional[SecurityProfileDescription] =
      Optional.Absent,
    behaviors: Optional[Iterable[zio.aws.iot.model.Behavior]] = Optional.Absent,
    alertTargets: Optional[
      Map[zio.aws.iot.model.AlertTargetType, zio.aws.iot.model.AlertTarget]
    ] = Optional.Absent,
    additionalMetricsToRetain: Optional[Iterable[BehaviorMetric]] =
      Optional.Absent,
    additionalMetricsToRetainV2: Optional[
      Iterable[zio.aws.iot.model.MetricToRetain]
    ] = Optional.Absent,
    version: Optional[Version] = Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    lastModifiedDate: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeSecurityProfileResponse = {
    import DescribeSecurityProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeSecurityProfileResponse
      .builder()
      .optionallyWith(
        securityProfileName.map(value =>
          SecurityProfileName.unwrap(value): java.lang.String
        )
      )(_.securityProfileName)
      .optionallyWith(
        securityProfileArn.map(value =>
          SecurityProfileArn.unwrap(value): java.lang.String
        )
      )(_.securityProfileArn)
      .optionallyWith(
        securityProfileDescription.map(value =>
          SecurityProfileDescription.unwrap(value): java.lang.String
        )
      )(_.securityProfileDescription)
      .optionallyWith(
        behaviors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.behaviors)
      .optionallyWith(
        alertTargets.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.alertTargetsWithStrings)
      .optionallyWith(
        additionalMetricsToRetain.map(value =>
          value.map { item =>
            BehaviorMetric.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.additionalMetricsToRetain)
      .optionallyWith(
        additionalMetricsToRetainV2.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalMetricsToRetainV2)
      .optionallyWith(
        version.map(value => Version.unwrap(value): java.lang.Long)
      )(_.version)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeSecurityProfileResponse.ReadOnly =
    zio.aws.iot.model.DescribeSecurityProfileResponse.wrap(buildAwsValue())
}
object DescribeSecurityProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeSecurityProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeSecurityProfileResponse =
      zio.aws.iot.model.DescribeSecurityProfileResponse(
        securityProfileName.map(value => value),
        securityProfileArn.map(value => value),
        securityProfileDescription.map(value => value),
        behaviors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        alertTargets.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        additionalMetricsToRetain.map(value => value),
        additionalMetricsToRetainV2.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        version.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value)
      )
    def securityProfileName: Optional[SecurityProfileName]
    def securityProfileArn: Optional[SecurityProfileArn]
    def securityProfileDescription: Optional[SecurityProfileDescription]
    def behaviors: Optional[List[zio.aws.iot.model.Behavior.ReadOnly]]
    def alertTargets: Optional[Map[
      zio.aws.iot.model.AlertTargetType,
      zio.aws.iot.model.AlertTarget.ReadOnly
    ]]
    def additionalMetricsToRetain: Optional[List[BehaviorMetric]]
    def additionalMetricsToRetainV2
        : Optional[List[zio.aws.iot.model.MetricToRetain.ReadOnly]]
    def version: Optional[Version]
    def creationDate: Optional[Timestamp]
    def lastModifiedDate: Optional[Timestamp]
    def getSecurityProfileName: ZIO[Any, AwsError, SecurityProfileName] =
      AwsError.unwrapOptionField("securityProfileName", securityProfileName)
    def getSecurityProfileArn: ZIO[Any, AwsError, SecurityProfileArn] =
      AwsError.unwrapOptionField("securityProfileArn", securityProfileArn)
    def getSecurityProfileDescription
        : ZIO[Any, AwsError, SecurityProfileDescription] =
      AwsError.unwrapOptionField(
        "securityProfileDescription",
        securityProfileDescription
      )
    def getBehaviors
        : ZIO[Any, AwsError, List[zio.aws.iot.model.Behavior.ReadOnly]] =
      AwsError.unwrapOptionField("behaviors", behaviors)
    def getAlertTargets: ZIO[Any, AwsError, Map[
      zio.aws.iot.model.AlertTargetType,
      zio.aws.iot.model.AlertTarget.ReadOnly
    ]] = AwsError.unwrapOptionField("alertTargets", alertTargets)
    def getAdditionalMetricsToRetain: ZIO[Any, AwsError, List[BehaviorMetric]] =
      AwsError.unwrapOptionField(
        "additionalMetricsToRetain",
        additionalMetricsToRetain
      )
    def getAdditionalMetricsToRetainV2
        : ZIO[Any, AwsError, List[zio.aws.iot.model.MetricToRetain.ReadOnly]] =
      AwsError.unwrapOptionField(
        "additionalMetricsToRetainV2",
        additionalMetricsToRetainV2
      )
    def getVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("version", version)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeSecurityProfileResponse
  ) extends zio.aws.iot.model.DescribeSecurityProfileResponse.ReadOnly {
    override val securityProfileName: Optional[SecurityProfileName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityProfileName())
        .map(value => zio.aws.iot.model.primitives.SecurityProfileName(value))
    override val securityProfileArn: Optional[SecurityProfileArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityProfileArn())
        .map(value => zio.aws.iot.model.primitives.SecurityProfileArn(value))
    override val securityProfileDescription
        : Optional[SecurityProfileDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.securityProfileDescription())
      .map(value =>
        zio.aws.iot.model.primitives.SecurityProfileDescription(value)
      )
    override val behaviors
        : Optional[List[zio.aws.iot.model.Behavior.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.behaviors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Behavior.wrap(item)
          }.toList
        )
    override val alertTargets: Optional[Map[
      zio.aws.iot.model.AlertTargetType,
      zio.aws.iot.model.AlertTarget.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.alertTargets())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.AlertTargetType
              .wrap(key) -> zio.aws.iot.model.AlertTarget.wrap(value)
          })
          .toMap
      )
    override val additionalMetricsToRetain: Optional[List[BehaviorMetric]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalMetricsToRetain())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.primitives.BehaviorMetric(item)
          }.toList
        )
    override val additionalMetricsToRetainV2
        : Optional[List[zio.aws.iot.model.MetricToRetain.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalMetricsToRetainV2())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.MetricToRetain.wrap(item)
          }.toList
        )
    override val version: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.iot.model.primitives.Version(value))
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val lastModifiedDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeSecurityProfileResponse
  ): zio.aws.iot.model.DescribeSecurityProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
