package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeStreamResponse(
    streamInfo: Optional[zio.aws.iot.model.StreamInfo] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeStreamResponse = {
    import DescribeStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeStreamResponse
      .builder()
      .optionallyWith(streamInfo.map(value => value.buildAwsValue()))(
        _.streamInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeStreamResponse.ReadOnly =
    zio.aws.iot.model.DescribeStreamResponse.wrap(buildAwsValue())
}
object DescribeStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeStreamResponse = zio.aws.iot.model
      .DescribeStreamResponse(streamInfo.map(value => value.asEditable))
    def streamInfo: Optional[zio.aws.iot.model.StreamInfo.ReadOnly]
    def getStreamInfo
        : ZIO[Any, AwsError, zio.aws.iot.model.StreamInfo.ReadOnly] =
      AwsError.unwrapOptionField("streamInfo", streamInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeStreamResponse
  ) extends zio.aws.iot.model.DescribeStreamResponse.ReadOnly {
    override val streamInfo: Optional[zio.aws.iot.model.StreamInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamInfo())
        .map(value => zio.aws.iot.model.StreamInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeStreamResponse
  ): zio.aws.iot.model.DescribeStreamResponse.ReadOnly = new Wrapper(impl)
}
