package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.ThingGroupName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeThingGroupRequest(thingGroupName: ThingGroupName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeThingGroupRequest = {
    import DescribeThingGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeThingGroupRequest
      .builder()
      .thingGroupName(ThingGroupName.unwrap(thingGroupName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeThingGroupRequest.ReadOnly =
    zio.aws.iot.model.DescribeThingGroupRequest.wrap(buildAwsValue())
}
object DescribeThingGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeThingGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeThingGroupRequest =
      zio.aws.iot.model.DescribeThingGroupRequest(thingGroupName)
    def thingGroupName: ThingGroupName
    def getThingGroupName: ZIO[Any, Nothing, ThingGroupName] =
      ZIO.succeed(thingGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeThingGroupRequest
  ) extends zio.aws.iot.model.DescribeThingGroupRequest.ReadOnly {
    override val thingGroupName: ThingGroupName =
      zio.aws.iot.model.primitives.ThingGroupName(impl.thingGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeThingGroupRequest
  ): zio.aws.iot.model.DescribeThingGroupRequest.ReadOnly = new Wrapper(impl)
}
