package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.TaskId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeThingRegistrationTaskRequest(taskId: TaskId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskRequest = {
    import DescribeThingRegistrationTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskRequest
      .builder()
      .taskId(TaskId.unwrap(taskId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DescribeThingRegistrationTaskRequest.ReadOnly =
    zio.aws.iot.model.DescribeThingRegistrationTaskRequest.wrap(buildAwsValue())
}
object DescribeThingRegistrationTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeThingRegistrationTaskRequest =
      zio.aws.iot.model.DescribeThingRegistrationTaskRequest(taskId)
    def taskId: TaskId
    def getTaskId: ZIO[Any, Nothing, TaskId] = ZIO.succeed(taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskRequest
  ) extends zio.aws.iot.model.DescribeThingRegistrationTaskRequest.ReadOnly {
    override val taskId: TaskId =
      zio.aws.iot.model.primitives.TaskId(impl.taskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskRequest
  ): zio.aws.iot.model.DescribeThingRegistrationTaskRequest.ReadOnly =
    new Wrapper(impl)
}
