package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  RegistryS3KeyName,
  ErrorMessage,
  RoleArn,
  Percentage,
  RegistryS3BucketName,
  Count,
  TemplateBody,
  LastModifiedDate,
  TaskId,
  CreationDate
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeThingRegistrationTaskResponse(
    taskId: Optional[TaskId] = Optional.Absent,
    creationDate: Optional[CreationDate] = Optional.Absent,
    lastModifiedDate: Optional[LastModifiedDate] = Optional.Absent,
    templateBody: Optional[TemplateBody] = Optional.Absent,
    inputFileBucket: Optional[RegistryS3BucketName] = Optional.Absent,
    inputFileKey: Optional[RegistryS3KeyName] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    status: Optional[zio.aws.iot.model.Status] = Optional.Absent,
    message: Optional[ErrorMessage] = Optional.Absent,
    successCount: Optional[Count] = Optional.Absent,
    failureCount: Optional[Count] = Optional.Absent,
    percentageProgress: Optional[Percentage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskResponse = {
    import DescribeThingRegistrationTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskResponse
      .builder()
      .optionallyWith(
        taskId.map(value => TaskId.unwrap(value): java.lang.String)
      )(_.taskId)
      .optionallyWith(
        creationDate.map(value => CreationDate.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => LastModifiedDate.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        templateBody.map(value => TemplateBody.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(
        inputFileBucket.map(value =>
          RegistryS3BucketName.unwrap(value): java.lang.String
        )
      )(_.inputFileBucket)
      .optionallyWith(
        inputFileKey.map(value =>
          RegistryS3KeyName.unwrap(value): java.lang.String
        )
      )(_.inputFileKey)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(successCount.map(value => Count.unwrap(value): Integer))(
        _.successCount
      )
      .optionallyWith(failureCount.map(value => Count.unwrap(value): Integer))(
        _.failureCount
      )
      .optionallyWith(
        percentageProgress.map(value => Percentage.unwrap(value): Integer)
      )(_.percentageProgress)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DescribeThingRegistrationTaskResponse.ReadOnly =
    zio.aws.iot.model.DescribeThingRegistrationTaskResponse
      .wrap(buildAwsValue())
}
object DescribeThingRegistrationTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeThingRegistrationTaskResponse =
      zio.aws.iot.model.DescribeThingRegistrationTaskResponse(
        taskId.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value),
        templateBody.map(value => value),
        inputFileBucket.map(value => value),
        inputFileKey.map(value => value),
        roleArn.map(value => value),
        status.map(value => value),
        message.map(value => value),
        successCount.map(value => value),
        failureCount.map(value => value),
        percentageProgress.map(value => value)
      )
    def taskId: Optional[TaskId]
    def creationDate: Optional[CreationDate]
    def lastModifiedDate: Optional[LastModifiedDate]
    def templateBody: Optional[TemplateBody]
    def inputFileBucket: Optional[RegistryS3BucketName]
    def inputFileKey: Optional[RegistryS3KeyName]
    def roleArn: Optional[RoleArn]
    def status: Optional[zio.aws.iot.model.Status]
    def message: Optional[ErrorMessage]
    def successCount: Optional[Count]
    def failureCount: Optional[Count]
    def percentageProgress: Optional[Percentage]
    def getTaskId: ZIO[Any, AwsError, TaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
    def getCreationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, LastModifiedDate] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getTemplateBody: ZIO[Any, AwsError, TemplateBody] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getInputFileBucket: ZIO[Any, AwsError, RegistryS3BucketName] =
      AwsError.unwrapOptionField("inputFileBucket", inputFileBucket)
    def getInputFileKey: ZIO[Any, AwsError, RegistryS3KeyName] =
      AwsError.unwrapOptionField("inputFileKey", inputFileKey)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.Status] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
    def getSuccessCount: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("successCount", successCount)
    def getFailureCount: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("failureCount", failureCount)
    def getPercentageProgress: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("percentageProgress", percentageProgress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskResponse
  ) extends zio.aws.iot.model.DescribeThingRegistrationTaskResponse.ReadOnly {
    override val taskId: Optional[TaskId] = zio.aws.core.internal
      .optionalFromNullable(impl.taskId())
      .map(value => zio.aws.iot.model.primitives.TaskId(value))
    override val creationDate: Optional[CreationDate] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.CreationDate(value))
    override val lastModifiedDate: Optional[LastModifiedDate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedDate())
        .map(value => zio.aws.iot.model.primitives.LastModifiedDate(value))
    override val templateBody: Optional[TemplateBody] = zio.aws.core.internal
      .optionalFromNullable(impl.templateBody())
      .map(value => zio.aws.iot.model.primitives.TemplateBody(value))
    override val inputFileBucket: Optional[RegistryS3BucketName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputFileBucket())
        .map(value => zio.aws.iot.model.primitives.RegistryS3BucketName(value))
    override val inputFileKey: Optional[RegistryS3KeyName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputFileKey())
        .map(value => zio.aws.iot.model.primitives.RegistryS3KeyName(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.RoleArn(value))
    override val status: Optional[zio.aws.iot.model.Status] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iot.model.Status.wrap(value))
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.iot.model.primitives.ErrorMessage(value))
    override val successCount: Optional[Count] = zio.aws.core.internal
      .optionalFromNullable(impl.successCount())
      .map(value => zio.aws.iot.model.primitives.Count(value))
    override val failureCount: Optional[Count] = zio.aws.core.internal
      .optionalFromNullable(impl.failureCount())
      .map(value => zio.aws.iot.model.primitives.Count(value))
    override val percentageProgress: Optional[Percentage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.percentageProgress())
        .map(value => zio.aws.iot.model.primitives.Percentage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskResponse
  ): zio.aws.iot.model.DescribeThingRegistrationTaskResponse.ReadOnly =
    new Wrapper(impl)
}
