package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.ThingTypeName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeThingTypeRequest(thingTypeName: ThingTypeName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeThingTypeRequest = {
    import DescribeThingTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeThingTypeRequest
      .builder()
      .thingTypeName(ThingTypeName.unwrap(thingTypeName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeThingTypeRequest.ReadOnly =
    zio.aws.iot.model.DescribeThingTypeRequest.wrap(buildAwsValue())
}
object DescribeThingTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeThingTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeThingTypeRequest =
      zio.aws.iot.model.DescribeThingTypeRequest(thingTypeName)
    def thingTypeName: ThingTypeName
    def getThingTypeName: ZIO[Any, Nothing, ThingTypeName] =
      ZIO.succeed(thingTypeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeThingTypeRequest
  ) extends zio.aws.iot.model.DescribeThingTypeRequest.ReadOnly {
    override val thingTypeName: ThingTypeName =
      zio.aws.iot.model.primitives.ThingTypeName(impl.thingTypeName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeThingTypeRequest
  ): zio.aws.iot.model.DescribeThingTypeRequest.ReadOnly = new Wrapper(impl)
}
