package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{PolicyTarget, PolicyName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DetachPolicyRequest(
    policyName: PolicyName,
    target: PolicyTarget
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DetachPolicyRequest = {
    import DetachPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DetachPolicyRequest
      .builder()
      .policyName(PolicyName.unwrap(policyName): java.lang.String)
      .target(PolicyTarget.unwrap(target): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DetachPolicyRequest.ReadOnly =
    zio.aws.iot.model.DetachPolicyRequest.wrap(buildAwsValue())
}
object DetachPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DetachPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DetachPolicyRequest =
      zio.aws.iot.model.DetachPolicyRequest(policyName, target)
    def policyName: PolicyName
    def target: PolicyTarget
    def getPolicyName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(policyName)
    def getTarget: ZIO[Any, Nothing, PolicyTarget] = ZIO.succeed(target)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DetachPolicyRequest
  ) extends zio.aws.iot.model.DetachPolicyRequest.ReadOnly {
    override val policyName: PolicyName =
      zio.aws.iot.model.primitives.PolicyName(impl.policyName())
    override val target: PolicyTarget =
      zio.aws.iot.model.primitives.PolicyTarget(impl.target())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DetachPolicyRequest
  ): zio.aws.iot.model.DetachPolicyRequest.ReadOnly = new Wrapper(impl)
}
