package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{Principal, ThingName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DetachThingPrincipalRequest(
    thingName: ThingName,
    principal: Principal
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DetachThingPrincipalRequest = {
    import DetachThingPrincipalRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DetachThingPrincipalRequest
      .builder()
      .thingName(ThingName.unwrap(thingName): java.lang.String)
      .principal(Principal.unwrap(principal): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DetachThingPrincipalRequest.ReadOnly =
    zio.aws.iot.model.DetachThingPrincipalRequest.wrap(buildAwsValue())
}
object DetachThingPrincipalRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DetachThingPrincipalRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DetachThingPrincipalRequest =
      zio.aws.iot.model.DetachThingPrincipalRequest(thingName, principal)
    def thingName: ThingName
    def principal: Principal
    def getThingName: ZIO[Any, Nothing, ThingName] = ZIO.succeed(thingName)
    def getPrincipal: ZIO[Any, Nothing, Principal] = ZIO.succeed(principal)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DetachThingPrincipalRequest
  ) extends zio.aws.iot.model.DetachThingPrincipalRequest.ReadOnly {
    override val thingName: ThingName =
      zio.aws.iot.model.primitives.ThingName(impl.thingName())
    override val principal: Principal =
      zio.aws.iot.model.primitives.Principal(impl.principal())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DetachThingPrincipalRequest
  ): zio.aws.iot.model.DetachThingPrincipalRequest.ReadOnly = new Wrapper(impl)
}
