package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait DetectMitigationActionsTaskStatus {
  def unwrap: software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskStatus
}
object DetectMitigationActionsTaskStatus {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskStatus
  ): zio.aws.iot.model.DetectMitigationActionsTaskStatus = value match {
    case software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskStatus.SUCCESSFUL =>
      val r = SUCCESSFUL
      r
    case software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskStatus.CANCELED =>
      val r = CANCELED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iot.model.DetectMitigationActionsTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskStatus =
      software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS
      extends zio.aws.iot.model.DetectMitigationActionsTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskStatus =
      software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskStatus.IN_PROGRESS
  }
  case object SUCCESSFUL
      extends zio.aws.iot.model.DetectMitigationActionsTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskStatus =
      software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskStatus.SUCCESSFUL
  }
  case object FAILED
      extends zio.aws.iot.model.DetectMitigationActionsTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskStatus =
      software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskStatus.FAILED
  }
  case object CANCELED
      extends zio.aws.iot.model.DetectMitigationActionsTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskStatus =
      software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskStatus.CANCELED
  }
}
