package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ParameterKey,
  Regex,
  Example,
  JobDescription
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DocumentParameter(
    key: Optional[ParameterKey] = Optional.Absent,
    description: Optional[JobDescription] = Optional.Absent,
    regex: Optional[Regex] = Optional.Absent,
    example: Optional[Example] = Optional.Absent,
    optional: Optional[zio.aws.iot.model.primitives.Optional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DocumentParameter = {
    import DocumentParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DocumentParameter
      .builder()
      .optionallyWith(
        key.map(value => ParameterKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        description.map(value => JobDescription.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        regex.map(value => Regex.unwrap(value): java.lang.String)
      )(_.regex)
      .optionallyWith(
        example.map(value => Example.unwrap(value): java.lang.String)
      )(_.example)
      .optionallyWith(
        optional.map(value =>
          zio.aws.iot.model.primitives.Optional.unwrap(value): java.lang.Boolean
        )
      )(_.optional)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DocumentParameter.ReadOnly =
    zio.aws.iot.model.DocumentParameter.wrap(buildAwsValue())
}
object DocumentParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DocumentParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DocumentParameter =
      zio.aws.iot.model.DocumentParameter(
        key.map(value => value),
        description.map(value => value),
        regex.map(value => value),
        example.map(value => value),
        optional.map(value => value)
      )
    def key: Optional[ParameterKey]
    def description: Optional[JobDescription]
    def regex: Optional[Regex]
    def example: Optional[Example]
    def optional: Optional[zio.aws.iot.model.primitives.Optional]
    def getKey: ZIO[Any, AwsError, ParameterKey] =
      AwsError.unwrapOptionField("key", key)
    def getDescription: ZIO[Any, AwsError, JobDescription] =
      AwsError.unwrapOptionField("description", description)
    def getRegex: ZIO[Any, AwsError, Regex] =
      AwsError.unwrapOptionField("regex", regex)
    def getExample: ZIO[Any, AwsError, Example] =
      AwsError.unwrapOptionField("example", example)
    def getOptional: ZIO[Any, AwsError, zio.aws.iot.model.primitives.Optional] =
      AwsError.unwrapOptionField("optional", optional)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DocumentParameter
  ) extends zio.aws.iot.model.DocumentParameter.ReadOnly {
    override val key: Optional[ParameterKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.iot.model.primitives.ParameterKey(value))
    override val description: Optional[JobDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iot.model.primitives.JobDescription(value))
    override val regex: Optional[Regex] = zio.aws.core.internal
      .optionalFromNullable(impl.regex())
      .map(value => zio.aws.iot.model.primitives.Regex(value))
    override val example: Optional[Example] = zio.aws.core.internal
      .optionalFromNullable(impl.example())
      .map(value => zio.aws.iot.model.primitives.Example(value))
    override val optional: Optional[zio.aws.iot.model.primitives.Optional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optional())
        .map(value => zio.aws.iot.model.primitives.Optional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DocumentParameter
  ): zio.aws.iot.model.DocumentParameter.ReadOnly = new Wrapper(impl)
}
