package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait DomainConfigurationStatus {
  def unwrap
      : software.amazon.awssdk.services.iot.model.DomainConfigurationStatus
}
object DomainConfigurationStatus {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.DomainConfigurationStatus
  ): zio.aws.iot.model.DomainConfigurationStatus = value match {
    case software.amazon.awssdk.services.iot.model.DomainConfigurationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.DomainConfigurationStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.iot.model.DomainConfigurationStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iot.model.DomainConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.DomainConfigurationStatus =
      software.amazon.awssdk.services.iot.model.DomainConfigurationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.iot.model.DomainConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.DomainConfigurationStatus =
      software.amazon.awssdk.services.iot.model.DomainConfigurationStatus.ENABLED
  }
  case object DISABLED extends zio.aws.iot.model.DomainConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.DomainConfigurationStatus =
      software.amazon.awssdk.services.iot.model.DomainConfigurationStatus.DISABLED
  }
}
