package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AwsArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DynamoDBv2Action(
    roleArn: AwsArn,
    putItem: zio.aws.iot.model.PutItemInput
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DynamoDBv2Action = {
    import DynamoDBv2Action.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DynamoDBv2Action
      .builder()
      .roleArn(AwsArn.unwrap(roleArn): java.lang.String)
      .putItem(putItem.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DynamoDBv2Action.ReadOnly =
    zio.aws.iot.model.DynamoDBv2Action.wrap(buildAwsValue())
}
object DynamoDBv2Action {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DynamoDBv2Action
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DynamoDBv2Action =
      zio.aws.iot.model.DynamoDBv2Action(roleArn, putItem.asEditable)
    def roleArn: AwsArn
    def putItem: zio.aws.iot.model.PutItemInput.ReadOnly
    def getRoleArn: ZIO[Any, Nothing, AwsArn] = ZIO.succeed(roleArn)
    def getPutItem: ZIO[Any, Nothing, zio.aws.iot.model.PutItemInput.ReadOnly] =
      ZIO.succeed(putItem)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DynamoDBv2Action
  ) extends zio.aws.iot.model.DynamoDBv2Action.ReadOnly {
    override val roleArn: AwsArn =
      zio.aws.iot.model.primitives.AwsArn(impl.roleArn())
    override val putItem: zio.aws.iot.model.PutItemInput.ReadOnly =
      zio.aws.iot.model.PutItemInput.wrap(impl.putItem())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DynamoDBv2Action
  ): zio.aws.iot.model.DynamoDBv2Action.ReadOnly = new Wrapper(impl)
}
