package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait DynamoKeyType {
  def unwrap: software.amazon.awssdk.services.iot.model.DynamoKeyType
}
object DynamoKeyType {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.DynamoKeyType
  ): zio.aws.iot.model.DynamoKeyType = value match {
    case software.amazon.awssdk.services.iot.model.DynamoKeyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.DynamoKeyType.STRING =>
      val r = STRING
      r
    case software.amazon.awssdk.services.iot.model.DynamoKeyType.NUMBER =>
      val r = NUMBER
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.DynamoKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.DynamoKeyType =
      software.amazon.awssdk.services.iot.model.DynamoKeyType.UNKNOWN_TO_SDK_VERSION
  }
  case object STRING extends zio.aws.iot.model.DynamoKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.DynamoKeyType =
      software.amazon.awssdk.services.iot.model.DynamoKeyType.STRING
  }
  case object NUMBER extends zio.aws.iot.model.DynamoKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.DynamoKeyType =
      software.amazon.awssdk.services.iot.model.DynamoKeyType.NUMBER
  }
}
