package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.RoleArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnableIoTLoggingParams(
    roleArnForLogging: RoleArn,
    logLevel: zio.aws.iot.model.LogLevel
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.EnableIoTLoggingParams = {
    import EnableIoTLoggingParams.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.EnableIoTLoggingParams
      .builder()
      .roleArnForLogging(RoleArn.unwrap(roleArnForLogging): java.lang.String)
      .logLevel(logLevel.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.EnableIoTLoggingParams.ReadOnly =
    zio.aws.iot.model.EnableIoTLoggingParams.wrap(buildAwsValue())
}
object EnableIoTLoggingParams {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.EnableIoTLoggingParams
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.EnableIoTLoggingParams =
      zio.aws.iot.model.EnableIoTLoggingParams(roleArnForLogging, logLevel)
    def roleArnForLogging: RoleArn
    def logLevel: zio.aws.iot.model.LogLevel
    def getRoleArnForLogging: ZIO[Any, Nothing, RoleArn] =
      ZIO.succeed(roleArnForLogging)
    def getLogLevel: ZIO[Any, Nothing, zio.aws.iot.model.LogLevel] =
      ZIO.succeed(logLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.EnableIoTLoggingParams
  ) extends zio.aws.iot.model.EnableIoTLoggingParams.ReadOnly {
    override val roleArnForLogging: RoleArn =
      zio.aws.iot.model.primitives.RoleArn(impl.roleArnForLogging())
    override val logLevel: zio.aws.iot.model.LogLevel =
      zio.aws.iot.model.LogLevel.wrap(impl.logLevel())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.EnableIoTLoggingParams
  ): zio.aws.iot.model.EnableIoTLoggingParams.ReadOnly = new Wrapper(impl)
}
