package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait EventType {
  def unwrap: software.amazon.awssdk.services.iot.model.EventType
}
object EventType {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.EventType
  ): zio.aws.iot.model.EventType = value match {
    case software.amazon.awssdk.services.iot.model.EventType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.EventType.THING =>
      val r = THING
      r
    case software.amazon.awssdk.services.iot.model.EventType.THING_GROUP =>
      val r = THING_GROUP
      r
    case software.amazon.awssdk.services.iot.model.EventType.THING_TYPE =>
      val r = THING_TYPE
      r
    case software.amazon.awssdk.services.iot.model.EventType.THING_GROUP_MEMBERSHIP =>
      val r = THING_GROUP_MEMBERSHIP
      r
    case software.amazon.awssdk.services.iot.model.EventType.THING_GROUP_HIERARCHY =>
      val r = THING_GROUP_HIERARCHY
      r
    case software.amazon.awssdk.services.iot.model.EventType.THING_TYPE_ASSOCIATION =>
      val r = THING_TYPE_ASSOCIATION
      r
    case software.amazon.awssdk.services.iot.model.EventType.JOB =>
      val r = JOB
      r
    case software.amazon.awssdk.services.iot.model.EventType.JOB_EXECUTION =>
      val r = JOB_EXECUTION
      r
    case software.amazon.awssdk.services.iot.model.EventType.POLICY =>
      val r = POLICY
      r
    case software.amazon.awssdk.services.iot.model.EventType.CERTIFICATE =>
      val r = CERTIFICATE
      r
    case software.amazon.awssdk.services.iot.model.EventType.CA_CERTIFICATE =>
      val r = CA_CERTIFICATE
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.EventType {
    override def unwrap: software.amazon.awssdk.services.iot.model.EventType =
      software.amazon.awssdk.services.iot.model.EventType.UNKNOWN_TO_SDK_VERSION
  }
  case object THING extends zio.aws.iot.model.EventType {
    override def unwrap: software.amazon.awssdk.services.iot.model.EventType =
      software.amazon.awssdk.services.iot.model.EventType.THING
  }
  case object THING_GROUP extends zio.aws.iot.model.EventType {
    override def unwrap: software.amazon.awssdk.services.iot.model.EventType =
      software.amazon.awssdk.services.iot.model.EventType.THING_GROUP
  }
  case object THING_TYPE extends zio.aws.iot.model.EventType {
    override def unwrap: software.amazon.awssdk.services.iot.model.EventType =
      software.amazon.awssdk.services.iot.model.EventType.THING_TYPE
  }
  case object THING_GROUP_MEMBERSHIP extends zio.aws.iot.model.EventType {
    override def unwrap: software.amazon.awssdk.services.iot.model.EventType =
      software.amazon.awssdk.services.iot.model.EventType.THING_GROUP_MEMBERSHIP
  }
  case object THING_GROUP_HIERARCHY extends zio.aws.iot.model.EventType {
    override def unwrap: software.amazon.awssdk.services.iot.model.EventType =
      software.amazon.awssdk.services.iot.model.EventType.THING_GROUP_HIERARCHY
  }
  case object THING_TYPE_ASSOCIATION extends zio.aws.iot.model.EventType {
    override def unwrap: software.amazon.awssdk.services.iot.model.EventType =
      software.amazon.awssdk.services.iot.model.EventType.THING_TYPE_ASSOCIATION
  }
  case object JOB extends zio.aws.iot.model.EventType {
    override def unwrap: software.amazon.awssdk.services.iot.model.EventType =
      software.amazon.awssdk.services.iot.model.EventType.JOB
  }
  case object JOB_EXECUTION extends zio.aws.iot.model.EventType {
    override def unwrap: software.amazon.awssdk.services.iot.model.EventType =
      software.amazon.awssdk.services.iot.model.EventType.JOB_EXECUTION
  }
  case object POLICY extends zio.aws.iot.model.EventType {
    override def unwrap: software.amazon.awssdk.services.iot.model.EventType =
      software.amazon.awssdk.services.iot.model.EventType.POLICY
  }
  case object CERTIFICATE extends zio.aws.iot.model.EventType {
    override def unwrap: software.amazon.awssdk.services.iot.model.EventType =
      software.amazon.awssdk.services.iot.model.EventType.CERTIFICATE
  }
  case object CA_CERTIFICATE extends zio.aws.iot.model.EventType {
    override def unwrap: software.amazon.awssdk.services.iot.model.EventType =
      software.amazon.awssdk.services.iot.model.EventType.CA_CERTIFICATE
  }
}
