package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{IncrementFactor, RolloutRatePerMinute}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ExponentialRolloutRate(
    baseRatePerMinute: RolloutRatePerMinute,
    incrementFactor: IncrementFactor,
    rateIncreaseCriteria: zio.aws.iot.model.RateIncreaseCriteria
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ExponentialRolloutRate = {
    import ExponentialRolloutRate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ExponentialRolloutRate
      .builder()
      .baseRatePerMinute(
        RolloutRatePerMinute.unwrap(baseRatePerMinute): Integer
      )
      .incrementFactor(
        IncrementFactor.unwrap(incrementFactor): java.lang.Double
      )
      .rateIncreaseCriteria(rateIncreaseCriteria.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ExponentialRolloutRate.ReadOnly =
    zio.aws.iot.model.ExponentialRolloutRate.wrap(buildAwsValue())
}
object ExponentialRolloutRate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ExponentialRolloutRate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ExponentialRolloutRate =
      zio.aws.iot.model.ExponentialRolloutRate(
        baseRatePerMinute,
        incrementFactor,
        rateIncreaseCriteria.asEditable
      )
    def baseRatePerMinute: RolloutRatePerMinute
    def incrementFactor: IncrementFactor
    def rateIncreaseCriteria: zio.aws.iot.model.RateIncreaseCriteria.ReadOnly
    def getBaseRatePerMinute: ZIO[Any, Nothing, RolloutRatePerMinute] =
      ZIO.succeed(baseRatePerMinute)
    def getIncrementFactor: ZIO[Any, Nothing, IncrementFactor] =
      ZIO.succeed(incrementFactor)
    def getRateIncreaseCriteria
        : ZIO[Any, Nothing, zio.aws.iot.model.RateIncreaseCriteria.ReadOnly] =
      ZIO.succeed(rateIncreaseCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ExponentialRolloutRate
  ) extends zio.aws.iot.model.ExponentialRolloutRate.ReadOnly {
    override val baseRatePerMinute: RolloutRatePerMinute =
      zio.aws.iot.model.primitives
        .RolloutRatePerMinute(impl.baseRatePerMinute())
    override val incrementFactor: IncrementFactor =
      zio.aws.iot.model.primitives.IncrementFactor(impl.incrementFactor())
    override val rateIncreaseCriteria
        : zio.aws.iot.model.RateIncreaseCriteria.ReadOnly =
      zio.aws.iot.model.RateIncreaseCriteria.wrap(impl.rateIncreaseCriteria())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ExponentialRolloutRate
  ): zio.aws.iot.model.ExponentialRolloutRate.ReadOnly = new Wrapper(impl)
}
