package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.FieldName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Field(
    name: Optional[FieldName] = Optional.Absent,
    `type`: Optional[zio.aws.iot.model.FieldType] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.Field = {
    import Field.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.Field
      .builder()
      .optionallyWith(
        name.map(value => FieldName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.Field.ReadOnly =
    zio.aws.iot.model.Field.wrap(buildAwsValue())
}
object Field {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.Field] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.Field = zio.aws.iot.model
      .Field(name.map(value => value), `type`.map(value => value))
    def name: Optional[FieldName]
    def `type`: Optional[zio.aws.iot.model.FieldType]
    def getName: ZIO[Any, AwsError, FieldName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.iot.model.FieldType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.Field
  ) extends zio.aws.iot.model.Field.ReadOnly {
    override val name: Optional[FieldName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.iot.model.primitives.FieldName(value))
    override val `type`: Optional[zio.aws.iot.model.FieldType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.iot.model.FieldType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.Field
  ): zio.aws.iot.model.Field.ReadOnly = new Wrapper(impl)
}
