package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait FieldType {
  def unwrap: software.amazon.awssdk.services.iot.model.FieldType
}
object FieldType {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.FieldType
  ): zio.aws.iot.model.FieldType = value match {
    case software.amazon.awssdk.services.iot.model.FieldType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.FieldType.NUMBER =>
      val r = Number
      r
    case software.amazon.awssdk.services.iot.model.FieldType.STRING =>
      val r = String
      r
    case software.amazon.awssdk.services.iot.model.FieldType.BOOLEAN =>
      val r = Boolean
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.FieldType {
    override def unwrap: software.amazon.awssdk.services.iot.model.FieldType =
      software.amazon.awssdk.services.iot.model.FieldType.UNKNOWN_TO_SDK_VERSION
  }
  case object Number extends zio.aws.iot.model.FieldType {
    override def unwrap: software.amazon.awssdk.services.iot.model.FieldType =
      software.amazon.awssdk.services.iot.model.FieldType.NUMBER
  }
  case object String extends zio.aws.iot.model.FieldType {
    override def unwrap: software.amazon.awssdk.services.iot.model.FieldType =
      software.amazon.awssdk.services.iot.model.FieldType.STRING
  }
  case object Boolean extends zio.aws.iot.model.FieldType {
    override def unwrap: software.amazon.awssdk.services.iot.model.FieldType =
      software.amazon.awssdk.services.iot.model.FieldType.BOOLEAN
  }
}
