package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  NextToken,
  TinyMaxResults,
  SecurityProfileName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetBehaviorModelTrainingSummariesRequest(
    securityProfileName: Optional[SecurityProfileName] = Optional.Absent,
    maxResults: Optional[TinyMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesRequest = {
    import GetBehaviorModelTrainingSummariesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesRequest
      .builder()
      .optionallyWith(
        securityProfileName.map(value =>
          SecurityProfileName.unwrap(value): java.lang.String
        )
      )(_.securityProfileName)
      .optionallyWith(
        maxResults.map(value => TinyMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.GetBehaviorModelTrainingSummariesRequest.ReadOnly =
    zio.aws.iot.model.GetBehaviorModelTrainingSummariesRequest
      .wrap(buildAwsValue())
}
object GetBehaviorModelTrainingSummariesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetBehaviorModelTrainingSummariesRequest =
      zio.aws.iot.model.GetBehaviorModelTrainingSummariesRequest(
        securityProfileName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def securityProfileName: Optional[SecurityProfileName]
    def maxResults: Optional[TinyMaxResults]
    def nextToken: Optional[NextToken]
    def getSecurityProfileName: ZIO[Any, AwsError, SecurityProfileName] =
      AwsError.unwrapOptionField("securityProfileName", securityProfileName)
    def getMaxResults: ZIO[Any, AwsError, TinyMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesRequest
  ) extends zio.aws.iot.model.GetBehaviorModelTrainingSummariesRequest.ReadOnly {
    override val securityProfileName: Optional[SecurityProfileName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityProfileName())
        .map(value => zio.aws.iot.model.primitives.SecurityProfileName(value))
    override val maxResults: Optional[TinyMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.TinyMaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesRequest
  ): zio.aws.iot.model.GetBehaviorModelTrainingSummariesRequest.ReadOnly =
    new Wrapper(impl)
}
