package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.Count
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetCardinalityResponse(
    cardinality: Optional[Count] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetCardinalityResponse = {
    import GetCardinalityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetCardinalityResponse
      .builder()
      .optionallyWith(cardinality.map(value => Count.unwrap(value): Integer))(
        _.cardinality
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetCardinalityResponse.ReadOnly =
    zio.aws.iot.model.GetCardinalityResponse.wrap(buildAwsValue())
}
object GetCardinalityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetCardinalityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetCardinalityResponse =
      zio.aws.iot.model.GetCardinalityResponse(cardinality.map(value => value))
    def cardinality: Optional[Count]
    def getCardinality: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("cardinality", cardinality)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetCardinalityResponse
  ) extends zio.aws.iot.model.GetCardinalityResponse.ReadOnly {
    override val cardinality: Optional[Count] = zio.aws.core.internal
      .optionalFromNullable(impl.cardinality())
      .map(value => zio.aws.iot.model.primitives.Count(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetCardinalityResponse
  ): zio.aws.iot.model.GetCardinalityResponse.ReadOnly = new Wrapper(impl)
}
