package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetEffectivePoliciesResponse(
    effectivePolicies: Optional[Iterable[zio.aws.iot.model.EffectivePolicy]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetEffectivePoliciesResponse = {
    import GetEffectivePoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetEffectivePoliciesResponse
      .builder()
      .optionallyWith(
        effectivePolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.effectivePolicies)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetEffectivePoliciesResponse.ReadOnly =
    zio.aws.iot.model.GetEffectivePoliciesResponse.wrap(buildAwsValue())
}
object GetEffectivePoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetEffectivePoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetEffectivePoliciesResponse =
      zio.aws.iot.model.GetEffectivePoliciesResponse(
        effectivePolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def effectivePolicies
        : Optional[List[zio.aws.iot.model.EffectivePolicy.ReadOnly]]
    def getEffectivePolicies
        : ZIO[Any, AwsError, List[zio.aws.iot.model.EffectivePolicy.ReadOnly]] =
      AwsError.unwrapOptionField("effectivePolicies", effectivePolicies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetEffectivePoliciesResponse
  ) extends zio.aws.iot.model.GetEffectivePoliciesResponse.ReadOnly {
    override val effectivePolicies
        : Optional[List[zio.aws.iot.model.EffectivePolicy.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.effectivePolicies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.EffectivePolicy.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetEffectivePoliciesResponse
  ): zio.aws.iot.model.GetEffectivePoliciesResponse.ReadOnly = new Wrapper(impl)
}
