package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.JobId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetJobDocumentRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetJobDocumentRequest = {
    import GetJobDocumentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetJobDocumentRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetJobDocumentRequest.ReadOnly =
    zio.aws.iot.model.GetJobDocumentRequest.wrap(buildAwsValue())
}
object GetJobDocumentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetJobDocumentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetJobDocumentRequest =
      zio.aws.iot.model.GetJobDocumentRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetJobDocumentRequest
  ) extends zio.aws.iot.model.GetJobDocumentRequest.ReadOnly {
    override val jobId: JobId = zio.aws.iot.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetJobDocumentRequest
  ): zio.aws.iot.model.GetJobDocumentRequest.ReadOnly = new Wrapper(impl)
}
