package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.OTAUpdateId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetOtaUpdateRequest(otaUpdateId: OTAUpdateId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetOtaUpdateRequest = {
    import GetOtaUpdateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetOtaUpdateRequest
      .builder()
      .otaUpdateId(OTAUpdateId.unwrap(otaUpdateId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetOtaUpdateRequest.ReadOnly =
    zio.aws.iot.model.GetOtaUpdateRequest.wrap(buildAwsValue())
}
object GetOtaUpdateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetOtaUpdateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetOtaUpdateRequest =
      zio.aws.iot.model.GetOtaUpdateRequest(otaUpdateId)
    def otaUpdateId: OTAUpdateId
    def getOtaUpdateId: ZIO[Any, Nothing, OTAUpdateId] =
      ZIO.succeed(otaUpdateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetOtaUpdateRequest
  ) extends zio.aws.iot.model.GetOtaUpdateRequest.ReadOnly {
    override val otaUpdateId: OTAUpdateId =
      zio.aws.iot.model.primitives.OTAUpdateId(impl.otaUpdateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetOtaUpdateRequest
  ): zio.aws.iot.model.GetOtaUpdateRequest.ReadOnly = new Wrapper(impl)
}
