package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.PolicyName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetPolicyRequest(policyName: PolicyName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetPolicyRequest = {
    import GetPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetPolicyRequest
      .builder()
      .policyName(PolicyName.unwrap(policyName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetPolicyRequest.ReadOnly =
    zio.aws.iot.model.GetPolicyRequest.wrap(buildAwsValue())
}
object GetPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetPolicyRequest =
      zio.aws.iot.model.GetPolicyRequest(policyName)
    def policyName: PolicyName
    def getPolicyName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(policyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetPolicyRequest
  ) extends zio.aws.iot.model.GetPolicyRequest.ReadOnly {
    override val policyName: PolicyName =
      zio.aws.iot.model.primitives.PolicyName(impl.policyName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetPolicyRequest
  ): zio.aws.iot.model.GetPolicyRequest.ReadOnly = new Wrapper(impl)
}
