package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  PolicyArn,
  PolicyName,
  DateType,
  PolicyVersionId,
  PolicyDocument,
  GenerationId
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetPolicyResponse(
    policyName: Optional[PolicyName] = Optional.Absent,
    policyArn: Optional[PolicyArn] = Optional.Absent,
    policyDocument: Optional[PolicyDocument] = Optional.Absent,
    defaultVersionId: Optional[PolicyVersionId] = Optional.Absent,
    creationDate: Optional[DateType] = Optional.Absent,
    lastModifiedDate: Optional[DateType] = Optional.Absent,
    generationId: Optional[GenerationId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetPolicyResponse = {
    import GetPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetPolicyResponse
      .builder()
      .optionallyWith(
        policyName.map(value => PolicyName.unwrap(value): java.lang.String)
      )(_.policyName)
      .optionallyWith(
        policyArn.map(value => PolicyArn.unwrap(value): java.lang.String)
      )(_.policyArn)
      .optionallyWith(
        policyDocument.map(value =>
          PolicyDocument.unwrap(value): java.lang.String
        )
      )(_.policyDocument)
      .optionallyWith(
        defaultVersionId.map(value =>
          PolicyVersionId.unwrap(value): java.lang.String
        )
      )(_.defaultVersionId)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        generationId.map(value => GenerationId.unwrap(value): java.lang.String)
      )(_.generationId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetPolicyResponse.ReadOnly =
    zio.aws.iot.model.GetPolicyResponse.wrap(buildAwsValue())
}
object GetPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetPolicyResponse =
      zio.aws.iot.model.GetPolicyResponse(
        policyName.map(value => value),
        policyArn.map(value => value),
        policyDocument.map(value => value),
        defaultVersionId.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value),
        generationId.map(value => value)
      )
    def policyName: Optional[PolicyName]
    def policyArn: Optional[PolicyArn]
    def policyDocument: Optional[PolicyDocument]
    def defaultVersionId: Optional[PolicyVersionId]
    def creationDate: Optional[DateType]
    def lastModifiedDate: Optional[DateType]
    def generationId: Optional[GenerationId]
    def getPolicyName: ZIO[Any, AwsError, PolicyName] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getPolicyArn: ZIO[Any, AwsError, PolicyArn] =
      AwsError.unwrapOptionField("policyArn", policyArn)
    def getPolicyDocument: ZIO[Any, AwsError, PolicyDocument] =
      AwsError.unwrapOptionField("policyDocument", policyDocument)
    def getDefaultVersionId: ZIO[Any, AwsError, PolicyVersionId] =
      AwsError.unwrapOptionField("defaultVersionId", defaultVersionId)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getGenerationId: ZIO[Any, AwsError, GenerationId] =
      AwsError.unwrapOptionField("generationId", generationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetPolicyResponse
  ) extends zio.aws.iot.model.GetPolicyResponse.ReadOnly {
    override val policyName: Optional[PolicyName] = zio.aws.core.internal
      .optionalFromNullable(impl.policyName())
      .map(value => zio.aws.iot.model.primitives.PolicyName(value))
    override val policyArn: Optional[PolicyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.policyArn())
      .map(value => zio.aws.iot.model.primitives.PolicyArn(value))
    override val policyDocument: Optional[PolicyDocument] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyDocument())
        .map(value => zio.aws.iot.model.primitives.PolicyDocument(value))
    override val defaultVersionId: Optional[PolicyVersionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultVersionId())
        .map(value => zio.aws.iot.model.primitives.PolicyVersionId(value))
    override val creationDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val lastModifiedDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val generationId: Optional[GenerationId] = zio.aws.core.internal
      .optionalFromNullable(impl.generationId())
      .map(value => zio.aws.iot.model.primitives.GenerationId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetPolicyResponse
  ): zio.aws.iot.model.GetPolicyResponse.ReadOnly = new Wrapper(impl)
}
