package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetStatisticsResponse(
    statistics: Optional[zio.aws.iot.model.Statistics] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetStatisticsResponse = {
    import GetStatisticsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetStatisticsResponse
      .builder()
      .optionallyWith(statistics.map(value => value.buildAwsValue()))(
        _.statistics
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetStatisticsResponse.ReadOnly =
    zio.aws.iot.model.GetStatisticsResponse.wrap(buildAwsValue())
}
object GetStatisticsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetStatisticsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetStatisticsResponse = zio.aws.iot.model
      .GetStatisticsResponse(statistics.map(value => value.asEditable))
    def statistics: Optional[zio.aws.iot.model.Statistics.ReadOnly]
    def getStatistics
        : ZIO[Any, AwsError, zio.aws.iot.model.Statistics.ReadOnly] =
      AwsError.unwrapOptionField("statistics", statistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetStatisticsResponse
  ) extends zio.aws.iot.model.GetStatisticsResponse.ReadOnly {
    override val statistics: Optional[zio.aws.iot.model.Statistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistics())
        .map(value => zio.aws.iot.model.Statistics.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetStatisticsResponse
  ): zio.aws.iot.model.GetStatisticsResponse.ReadOnly = new Wrapper(impl)
}
