package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetTopicRuleDestinationResponse(
    topicRuleDestination: Optional[zio.aws.iot.model.TopicRuleDestination] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetTopicRuleDestinationResponse = {
    import GetTopicRuleDestinationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetTopicRuleDestinationResponse
      .builder()
      .optionallyWith(topicRuleDestination.map(value => value.buildAwsValue()))(
        _.topicRuleDestination
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetTopicRuleDestinationResponse.ReadOnly =
    zio.aws.iot.model.GetTopicRuleDestinationResponse.wrap(buildAwsValue())
}
object GetTopicRuleDestinationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetTopicRuleDestinationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetTopicRuleDestinationResponse =
      zio.aws.iot.model.GetTopicRuleDestinationResponse(
        topicRuleDestination.map(value => value.asEditable)
      )
    def topicRuleDestination
        : Optional[zio.aws.iot.model.TopicRuleDestination.ReadOnly]
    def getTopicRuleDestination
        : ZIO[Any, AwsError, zio.aws.iot.model.TopicRuleDestination.ReadOnly] =
      AwsError.unwrapOptionField("topicRuleDestination", topicRuleDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetTopicRuleDestinationResponse
  ) extends zio.aws.iot.model.GetTopicRuleDestinationResponse.ReadOnly {
    override val topicRuleDestination
        : Optional[zio.aws.iot.model.TopicRuleDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.topicRuleDestination())
        .map(value => zio.aws.iot.model.TopicRuleDestination.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetTopicRuleDestinationResponse
  ): zio.aws.iot.model.GetTopicRuleDestinationResponse.ReadOnly = new Wrapper(
    impl
  )
}
