package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HttpAuthorization(
    sigv4: Optional[zio.aws.iot.model.SigV4Authorization] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.HttpAuthorization = {
    import HttpAuthorization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.HttpAuthorization
      .builder()
      .optionallyWith(sigv4.map(value => value.buildAwsValue()))(_.sigv4)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.HttpAuthorization.ReadOnly =
    zio.aws.iot.model.HttpAuthorization.wrap(buildAwsValue())
}
object HttpAuthorization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.HttpAuthorization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.HttpAuthorization =
      zio.aws.iot.model.HttpAuthorization(sigv4.map(value => value.asEditable))
    def sigv4: Optional[zio.aws.iot.model.SigV4Authorization.ReadOnly]
    def getSigv4
        : ZIO[Any, AwsError, zio.aws.iot.model.SigV4Authorization.ReadOnly] =
      AwsError.unwrapOptionField("sigv4", sigv4)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.HttpAuthorization
  ) extends zio.aws.iot.model.HttpAuthorization.ReadOnly {
    override val sigv4
        : Optional[zio.aws.iot.model.SigV4Authorization.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sigv4())
        .map(value => zio.aws.iot.model.SigV4Authorization.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.HttpAuthorization
  ): zio.aws.iot.model.HttpAuthorization.ReadOnly = new Wrapper(impl)
}
