package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.Url
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class HttpUrlDestinationConfiguration(confirmationUrl: Url) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.HttpUrlDestinationConfiguration = {
    import HttpUrlDestinationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.HttpUrlDestinationConfiguration
      .builder()
      .confirmationUrl(Url.unwrap(confirmationUrl): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.HttpUrlDestinationConfiguration.ReadOnly =
    zio.aws.iot.model.HttpUrlDestinationConfiguration.wrap(buildAwsValue())
}
object HttpUrlDestinationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.HttpUrlDestinationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.HttpUrlDestinationConfiguration =
      zio.aws.iot.model.HttpUrlDestinationConfiguration(confirmationUrl)
    def confirmationUrl: Url
    def getConfirmationUrl: ZIO[Any, Nothing, Url] =
      ZIO.succeed(confirmationUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.HttpUrlDestinationConfiguration
  ) extends zio.aws.iot.model.HttpUrlDestinationConfiguration.ReadOnly {
    override val confirmationUrl: Url =
      zio.aws.iot.model.primitives.Url(impl.confirmationUrl())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.HttpUrlDestinationConfiguration
  ): zio.aws.iot.model.HttpUrlDestinationConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
