package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait IndexStatus {
  def unwrap: software.amazon.awssdk.services.iot.model.IndexStatus
}
object IndexStatus {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.IndexStatus
  ): zio.aws.iot.model.IndexStatus = value match {
    case software.amazon.awssdk.services.iot.model.IndexStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.IndexStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.iot.model.IndexStatus.BUILDING =>
      val r = BUILDING
      r
    case software.amazon.awssdk.services.iot.model.IndexStatus.REBUILDING =>
      val r = REBUILDING
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.IndexStatus {
    override def unwrap: software.amazon.awssdk.services.iot.model.IndexStatus =
      software.amazon.awssdk.services.iot.model.IndexStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.iot.model.IndexStatus {
    override def unwrap: software.amazon.awssdk.services.iot.model.IndexStatus =
      software.amazon.awssdk.services.iot.model.IndexStatus.ACTIVE
  }
  case object BUILDING extends zio.aws.iot.model.IndexStatus {
    override def unwrap: software.amazon.awssdk.services.iot.model.IndexStatus =
      software.amazon.awssdk.services.iot.model.IndexStatus.BUILDING
  }
  case object REBUILDING extends zio.aws.iot.model.IndexStatus {
    override def unwrap: software.amazon.awssdk.services.iot.model.IndexStatus =
      software.amazon.awssdk.services.iot.model.IndexStatus.REBUILDING
  }
}
