package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{BatchMode, ChannelName, AwsArn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IotAnalyticsAction(
    channelArn: Optional[AwsArn] = Optional.Absent,
    channelName: Optional[ChannelName] = Optional.Absent,
    batchMode: Optional[BatchMode] = Optional.Absent,
    roleArn: Optional[AwsArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.IotAnalyticsAction = {
    import IotAnalyticsAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.IotAnalyticsAction
      .builder()
      .optionallyWith(
        channelArn.map(value => AwsArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        channelName.map(value => ChannelName.unwrap(value): java.lang.String)
      )(_.channelName)
      .optionallyWith(
        batchMode.map(value => BatchMode.unwrap(value): java.lang.Boolean)
      )(_.batchMode)
      .optionallyWith(
        roleArn.map(value => AwsArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.IotAnalyticsAction.ReadOnly =
    zio.aws.iot.model.IotAnalyticsAction.wrap(buildAwsValue())
}
object IotAnalyticsAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.IotAnalyticsAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.IotAnalyticsAction =
      zio.aws.iot.model.IotAnalyticsAction(
        channelArn.map(value => value),
        channelName.map(value => value),
        batchMode.map(value => value),
        roleArn.map(value => value)
      )
    def channelArn: Optional[AwsArn]
    def channelName: Optional[ChannelName]
    def batchMode: Optional[BatchMode]
    def roleArn: Optional[AwsArn]
    def getChannelArn: ZIO[Any, AwsError, AwsArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getChannelName: ZIO[Any, AwsError, ChannelName] =
      AwsError.unwrapOptionField("channelName", channelName)
    def getBatchMode: ZIO[Any, AwsError, BatchMode] =
      AwsError.unwrapOptionField("batchMode", batchMode)
    def getRoleArn: ZIO[Any, AwsError, AwsArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.IotAnalyticsAction
  ) extends zio.aws.iot.model.IotAnalyticsAction.ReadOnly {
    override val channelArn: Optional[AwsArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.iot.model.primitives.AwsArn(value))
    override val channelName: Optional[ChannelName] = zio.aws.core.internal
      .optionalFromNullable(impl.channelName())
      .map(value => zio.aws.iot.model.primitives.ChannelName(value))
    override val batchMode: Optional[BatchMode] = zio.aws.core.internal
      .optionalFromNullable(impl.batchMode())
      .map(value => zio.aws.iot.model.primitives.BatchMode(value))
    override val roleArn: Optional[AwsArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.AwsArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.IotAnalyticsAction
  ): zio.aws.iot.model.IotAnalyticsAction.ReadOnly = new Wrapper(impl)
}
