package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  ParameterKey,
  TargetArn,
  NamespaceId,
  Comment,
  ReasonCode,
  ParameterValue,
  JobTemplateArn,
  JobArn,
  DateType,
  Forced,
  JobId,
  BooleanWrapperObject,
  JobDescription
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Job(
    jobArn: Optional[JobArn] = Optional.Absent,
    jobId: Optional[JobId] = Optional.Absent,
    targetSelection: Optional[zio.aws.iot.model.TargetSelection] =
      Optional.Absent,
    status: Optional[zio.aws.iot.model.JobStatus] = Optional.Absent,
    forceCanceled: Optional[Forced] = Optional.Absent,
    reasonCode: Optional[ReasonCode] = Optional.Absent,
    comment: Optional[Comment] = Optional.Absent,
    targets: Optional[Iterable[TargetArn]] = Optional.Absent,
    description: Optional[JobDescription] = Optional.Absent,
    presignedUrlConfig: Optional[zio.aws.iot.model.PresignedUrlConfig] =
      Optional.Absent,
    jobExecutionsRolloutConfig: Optional[
      zio.aws.iot.model.JobExecutionsRolloutConfig
    ] = Optional.Absent,
    abortConfig: Optional[zio.aws.iot.model.AbortConfig] = Optional.Absent,
    createdAt: Optional[DateType] = Optional.Absent,
    lastUpdatedAt: Optional[DateType] = Optional.Absent,
    completedAt: Optional[DateType] = Optional.Absent,
    jobProcessDetails: Optional[zio.aws.iot.model.JobProcessDetails] =
      Optional.Absent,
    timeoutConfig: Optional[zio.aws.iot.model.TimeoutConfig] = Optional.Absent,
    namespaceId: Optional[NamespaceId] = Optional.Absent,
    jobTemplateArn: Optional[JobTemplateArn] = Optional.Absent,
    jobExecutionsRetryConfig: Optional[
      zio.aws.iot.model.JobExecutionsRetryConfig
    ] = Optional.Absent,
    documentParameters: Optional[Map[ParameterKey, ParameterValue]] =
      Optional.Absent,
    isConcurrent: Optional[BooleanWrapperObject] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.Job = {
    import Job.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.Job
      .builder()
      .optionallyWith(
        jobArn.map(value => JobArn.unwrap(value): java.lang.String)
      )(_.jobArn)
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(targetSelection.map(value => value.unwrap))(
        _.targetSelection
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        forceCanceled.map(value => Forced.unwrap(value): java.lang.Boolean)
      )(_.forceCanceled)
      .optionallyWith(
        reasonCode.map(value => ReasonCode.unwrap(value): java.lang.String)
      )(_.reasonCode)
      .optionallyWith(
        comment.map(value => Comment.unwrap(value): java.lang.String)
      )(_.comment)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            TargetArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        description.map(value => JobDescription.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(presignedUrlConfig.map(value => value.buildAwsValue()))(
        _.presignedUrlConfig
      )
      .optionallyWith(
        jobExecutionsRolloutConfig.map(value => value.buildAwsValue())
      )(_.jobExecutionsRolloutConfig)
      .optionallyWith(abortConfig.map(value => value.buildAwsValue()))(
        _.abortConfig
      )
      .optionallyWith(createdAt.map(value => DateType.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => DateType.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        completedAt.map(value => DateType.unwrap(value): Instant)
      )(_.completedAt)
      .optionallyWith(jobProcessDetails.map(value => value.buildAwsValue()))(
        _.jobProcessDetails
      )
      .optionallyWith(timeoutConfig.map(value => value.buildAwsValue()))(
        _.timeoutConfig
      )
      .optionallyWith(
        namespaceId.map(value => NamespaceId.unwrap(value): java.lang.String)
      )(_.namespaceId)
      .optionallyWith(
        jobTemplateArn.map(value =>
          JobTemplateArn.unwrap(value): java.lang.String
        )
      )(_.jobTemplateArn)
      .optionallyWith(
        jobExecutionsRetryConfig.map(value => value.buildAwsValue())
      )(_.jobExecutionsRetryConfig)
      .optionallyWith(
        documentParameters.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterKey.unwrap(key): java.lang.String) -> (ParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.documentParameters)
      .optionallyWith(
        isConcurrent.map(value =>
          BooleanWrapperObject.unwrap(value): java.lang.Boolean
        )
      )(_.isConcurrent)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.Job.ReadOnly =
    zio.aws.iot.model.Job.wrap(buildAwsValue())
}
object Job {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.Job] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.Job = zio.aws.iot.model.Job(
      jobArn.map(value => value),
      jobId.map(value => value),
      targetSelection.map(value => value),
      status.map(value => value),
      forceCanceled.map(value => value),
      reasonCode.map(value => value),
      comment.map(value => value),
      targets.map(value => value),
      description.map(value => value),
      presignedUrlConfig.map(value => value.asEditable),
      jobExecutionsRolloutConfig.map(value => value.asEditable),
      abortConfig.map(value => value.asEditable),
      createdAt.map(value => value),
      lastUpdatedAt.map(value => value),
      completedAt.map(value => value),
      jobProcessDetails.map(value => value.asEditable),
      timeoutConfig.map(value => value.asEditable),
      namespaceId.map(value => value),
      jobTemplateArn.map(value => value),
      jobExecutionsRetryConfig.map(value => value.asEditable),
      documentParameters.map(value => value),
      isConcurrent.map(value => value)
    )
    def jobArn: Optional[JobArn]
    def jobId: Optional[JobId]
    def targetSelection: Optional[zio.aws.iot.model.TargetSelection]
    def status: Optional[zio.aws.iot.model.JobStatus]
    def forceCanceled: Optional[Forced]
    def reasonCode: Optional[ReasonCode]
    def comment: Optional[Comment]
    def targets: Optional[List[TargetArn]]
    def description: Optional[JobDescription]
    def presignedUrlConfig
        : Optional[zio.aws.iot.model.PresignedUrlConfig.ReadOnly]
    def jobExecutionsRolloutConfig
        : Optional[zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly]
    def abortConfig: Optional[zio.aws.iot.model.AbortConfig.ReadOnly]
    def createdAt: Optional[DateType]
    def lastUpdatedAt: Optional[DateType]
    def completedAt: Optional[DateType]
    def jobProcessDetails
        : Optional[zio.aws.iot.model.JobProcessDetails.ReadOnly]
    def timeoutConfig: Optional[zio.aws.iot.model.TimeoutConfig.ReadOnly]
    def namespaceId: Optional[NamespaceId]
    def jobTemplateArn: Optional[JobTemplateArn]
    def jobExecutionsRetryConfig
        : Optional[zio.aws.iot.model.JobExecutionsRetryConfig.ReadOnly]
    def documentParameters: Optional[Map[ParameterKey, ParameterValue]]
    def isConcurrent: Optional[BooleanWrapperObject]
    def getJobArn: ZIO[Any, AwsError, JobArn] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getTargetSelection
        : ZIO[Any, AwsError, zio.aws.iot.model.TargetSelection] =
      AwsError.unwrapOptionField("targetSelection", targetSelection)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.JobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getForceCanceled: ZIO[Any, AwsError, Forced] =
      AwsError.unwrapOptionField("forceCanceled", forceCanceled)
    def getReasonCode: ZIO[Any, AwsError, ReasonCode] =
      AwsError.unwrapOptionField("reasonCode", reasonCode)
    def getComment: ZIO[Any, AwsError, Comment] =
      AwsError.unwrapOptionField("comment", comment)
    def getTargets: ZIO[Any, AwsError, List[TargetArn]] =
      AwsError.unwrapOptionField("targets", targets)
    def getDescription: ZIO[Any, AwsError, JobDescription] =
      AwsError.unwrapOptionField("description", description)
    def getPresignedUrlConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.PresignedUrlConfig.ReadOnly] =
      AwsError.unwrapOptionField("presignedUrlConfig", presignedUrlConfig)
    def getJobExecutionsRolloutConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "jobExecutionsRolloutConfig",
      jobExecutionsRolloutConfig
    )
    def getAbortConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.AbortConfig.ReadOnly] =
      AwsError.unwrapOptionField("abortConfig", abortConfig)
    def getCreatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getCompletedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("completedAt", completedAt)
    def getJobProcessDetails
        : ZIO[Any, AwsError, zio.aws.iot.model.JobProcessDetails.ReadOnly] =
      AwsError.unwrapOptionField("jobProcessDetails", jobProcessDetails)
    def getTimeoutConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.TimeoutConfig.ReadOnly] =
      AwsError.unwrapOptionField("timeoutConfig", timeoutConfig)
    def getNamespaceId: ZIO[Any, AwsError, NamespaceId] =
      AwsError.unwrapOptionField("namespaceId", namespaceId)
    def getJobTemplateArn: ZIO[Any, AwsError, JobTemplateArn] =
      AwsError.unwrapOptionField("jobTemplateArn", jobTemplateArn)
    def getJobExecutionsRetryConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.JobExecutionsRetryConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "jobExecutionsRetryConfig",
      jobExecutionsRetryConfig
    )
    def getDocumentParameters
        : ZIO[Any, AwsError, Map[ParameterKey, ParameterValue]] =
      AwsError.unwrapOptionField("documentParameters", documentParameters)
    def getIsConcurrent: ZIO[Any, AwsError, BooleanWrapperObject] =
      AwsError.unwrapOptionField("isConcurrent", isConcurrent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.Job
  ) extends zio.aws.iot.model.Job.ReadOnly {
    override val jobArn: Optional[JobArn] = zio.aws.core.internal
      .optionalFromNullable(impl.jobArn())
      .map(value => zio.aws.iot.model.primitives.JobArn(value))
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.iot.model.primitives.JobId(value))
    override val targetSelection: Optional[zio.aws.iot.model.TargetSelection] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetSelection())
        .map(value => zio.aws.iot.model.TargetSelection.wrap(value))
    override val status: Optional[zio.aws.iot.model.JobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iot.model.JobStatus.wrap(value))
    override val forceCanceled: Optional[Forced] = zio.aws.core.internal
      .optionalFromNullable(impl.forceCanceled())
      .map(value => zio.aws.iot.model.primitives.Forced(value))
    override val reasonCode: Optional[ReasonCode] = zio.aws.core.internal
      .optionalFromNullable(impl.reasonCode())
      .map(value => zio.aws.iot.model.primitives.ReasonCode(value))
    override val comment: Optional[Comment] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => zio.aws.iot.model.primitives.Comment(value))
    override val targets: Optional[List[TargetArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.targets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.TargetArn(item)
        }.toList
      )
    override val description: Optional[JobDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iot.model.primitives.JobDescription(value))
    override val presignedUrlConfig
        : Optional[zio.aws.iot.model.PresignedUrlConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.presignedUrlConfig())
        .map(value => zio.aws.iot.model.PresignedUrlConfig.wrap(value))
    override val jobExecutionsRolloutConfig
        : Optional[zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobExecutionsRolloutConfig())
        .map(value => zio.aws.iot.model.JobExecutionsRolloutConfig.wrap(value))
    override val abortConfig: Optional[zio.aws.iot.model.AbortConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.abortConfig())
        .map(value => zio.aws.iot.model.AbortConfig.wrap(value))
    override val createdAt: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val lastUpdatedAt: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val completedAt: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.completedAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val jobProcessDetails
        : Optional[zio.aws.iot.model.JobProcessDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobProcessDetails())
        .map(value => zio.aws.iot.model.JobProcessDetails.wrap(value))
    override val timeoutConfig
        : Optional[zio.aws.iot.model.TimeoutConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutConfig())
        .map(value => zio.aws.iot.model.TimeoutConfig.wrap(value))
    override val namespaceId: Optional[NamespaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceId())
      .map(value => zio.aws.iot.model.primitives.NamespaceId(value))
    override val jobTemplateArn: Optional[JobTemplateArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobTemplateArn())
        .map(value => zio.aws.iot.model.primitives.JobTemplateArn(value))
    override val jobExecutionsRetryConfig
        : Optional[zio.aws.iot.model.JobExecutionsRetryConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobExecutionsRetryConfig())
        .map(value => zio.aws.iot.model.JobExecutionsRetryConfig.wrap(value))
    override val documentParameters
        : Optional[Map[ParameterKey, ParameterValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.documentParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.primitives.ParameterKey(
              key
            ) -> zio.aws.iot.model.primitives.ParameterValue(value)
          })
          .toMap
      )
    override val isConcurrent: Optional[BooleanWrapperObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isConcurrent())
        .map(value => zio.aws.iot.model.primitives.BooleanWrapperObject(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.Job
  ): zio.aws.iot.model.Job.ReadOnly = new Wrapper(impl)
}
