package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait JobExecutionFailureType {
  def unwrap: software.amazon.awssdk.services.iot.model.JobExecutionFailureType
}
object JobExecutionFailureType {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.JobExecutionFailureType
  ): zio.aws.iot.model.JobExecutionFailureType = value match {
    case software.amazon.awssdk.services.iot.model.JobExecutionFailureType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.JobExecutionFailureType.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.iot.model.JobExecutionFailureType.REJECTED =>
      val r = REJECTED
      r
    case software.amazon.awssdk.services.iot.model.JobExecutionFailureType.TIMED_OUT =>
      val r = TIMED_OUT
      r
    case software.amazon.awssdk.services.iot.model.JobExecutionFailureType.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iot.model.JobExecutionFailureType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.JobExecutionFailureType =
      software.amazon.awssdk.services.iot.model.JobExecutionFailureType.UNKNOWN_TO_SDK_VERSION
  }
  case object FAILED extends zio.aws.iot.model.JobExecutionFailureType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.JobExecutionFailureType =
      software.amazon.awssdk.services.iot.model.JobExecutionFailureType.FAILED
  }
  case object REJECTED extends zio.aws.iot.model.JobExecutionFailureType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.JobExecutionFailureType =
      software.amazon.awssdk.services.iot.model.JobExecutionFailureType.REJECTED
  }
  case object TIMED_OUT extends zio.aws.iot.model.JobExecutionFailureType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.JobExecutionFailureType =
      software.amazon.awssdk.services.iot.model.JobExecutionFailureType.TIMED_OUT
  }
  case object ALL extends zio.aws.iot.model.JobExecutionFailureType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.JobExecutionFailureType =
      software.amazon.awssdk.services.iot.model.JobExecutionFailureType.ALL
  }
}
