package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait JobExecutionStatus {
  def unwrap: software.amazon.awssdk.services.iot.model.JobExecutionStatus
}
object JobExecutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.JobExecutionStatus
  ): zio.aws.iot.model.JobExecutionStatus = value match {
    case software.amazon.awssdk.services.iot.model.JobExecutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.JobExecutionStatus.QUEUED =>
      val r = QUEUED
      r
    case software.amazon.awssdk.services.iot.model.JobExecutionStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.iot.model.JobExecutionStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.iot.model.JobExecutionStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.iot.model.JobExecutionStatus.TIMED_OUT =>
      val r = TIMED_OUT
      r
    case software.amazon.awssdk.services.iot.model.JobExecutionStatus.REJECTED =>
      val r = REJECTED
      r
    case software.amazon.awssdk.services.iot.model.JobExecutionStatus.REMOVED =>
      val r = REMOVED
      r
    case software.amazon.awssdk.services.iot.model.JobExecutionStatus.CANCELED =>
      val r = CANCELED
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.JobExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.JobExecutionStatus =
      software.amazon.awssdk.services.iot.model.JobExecutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object QUEUED extends zio.aws.iot.model.JobExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.JobExecutionStatus =
      software.amazon.awssdk.services.iot.model.JobExecutionStatus.QUEUED
  }
  case object IN_PROGRESS extends zio.aws.iot.model.JobExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.JobExecutionStatus =
      software.amazon.awssdk.services.iot.model.JobExecutionStatus.IN_PROGRESS
  }
  case object SUCCEEDED extends zio.aws.iot.model.JobExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.JobExecutionStatus =
      software.amazon.awssdk.services.iot.model.JobExecutionStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.iot.model.JobExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.JobExecutionStatus =
      software.amazon.awssdk.services.iot.model.JobExecutionStatus.FAILED
  }
  case object TIMED_OUT extends zio.aws.iot.model.JobExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.JobExecutionStatus =
      software.amazon.awssdk.services.iot.model.JobExecutionStatus.TIMED_OUT
  }
  case object REJECTED extends zio.aws.iot.model.JobExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.JobExecutionStatus =
      software.amazon.awssdk.services.iot.model.JobExecutionStatus.REJECTED
  }
  case object REMOVED extends zio.aws.iot.model.JobExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.JobExecutionStatus =
      software.amazon.awssdk.services.iot.model.JobExecutionStatus.REMOVED
  }
  case object CANCELED extends zio.aws.iot.model.JobExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.JobExecutionStatus =
      software.amazon.awssdk.services.iot.model.JobExecutionStatus.CANCELED
  }
}
