package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{RetryAttempt, ExecutionNumber, DateType}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class JobExecutionSummary(
    status: Optional[zio.aws.iot.model.JobExecutionStatus] = Optional.Absent,
    queuedAt: Optional[DateType] = Optional.Absent,
    startedAt: Optional[DateType] = Optional.Absent,
    lastUpdatedAt: Optional[DateType] = Optional.Absent,
    executionNumber: Optional[ExecutionNumber] = Optional.Absent,
    retryAttempt: Optional[RetryAttempt] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.JobExecutionSummary = {
    import JobExecutionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.JobExecutionSummary
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(queuedAt.map(value => DateType.unwrap(value): Instant))(
        _.queuedAt
      )
      .optionallyWith(startedAt.map(value => DateType.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => DateType.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        executionNumber.map(value =>
          ExecutionNumber.unwrap(value): java.lang.Long
        )
      )(_.executionNumber)
      .optionallyWith(
        retryAttempt.map(value => RetryAttempt.unwrap(value): Integer)
      )(_.retryAttempt)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.JobExecutionSummary.ReadOnly =
    zio.aws.iot.model.JobExecutionSummary.wrap(buildAwsValue())
}
object JobExecutionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.JobExecutionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.JobExecutionSummary =
      zio.aws.iot.model.JobExecutionSummary(
        status.map(value => value),
        queuedAt.map(value => value),
        startedAt.map(value => value),
        lastUpdatedAt.map(value => value),
        executionNumber.map(value => value),
        retryAttempt.map(value => value)
      )
    def status: Optional[zio.aws.iot.model.JobExecutionStatus]
    def queuedAt: Optional[DateType]
    def startedAt: Optional[DateType]
    def lastUpdatedAt: Optional[DateType]
    def executionNumber: Optional[ExecutionNumber]
    def retryAttempt: Optional[RetryAttempt]
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.JobExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getQueuedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("queuedAt", queuedAt)
    def getStartedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getExecutionNumber: ZIO[Any, AwsError, ExecutionNumber] =
      AwsError.unwrapOptionField("executionNumber", executionNumber)
    def getRetryAttempt: ZIO[Any, AwsError, RetryAttempt] =
      AwsError.unwrapOptionField("retryAttempt", retryAttempt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.JobExecutionSummary
  ) extends zio.aws.iot.model.JobExecutionSummary.ReadOnly {
    override val status: Optional[zio.aws.iot.model.JobExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iot.model.JobExecutionStatus.wrap(value))
    override val queuedAt: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.queuedAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val startedAt: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val lastUpdatedAt: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val executionNumber: Optional[ExecutionNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionNumber())
        .map(value => zio.aws.iot.model.primitives.ExecutionNumber(value))
    override val retryAttempt: Optional[RetryAttempt] = zio.aws.core.internal
      .optionalFromNullable(impl.retryAttempt())
      .map(value => zio.aws.iot.model.primitives.RetryAttempt(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.JobExecutionSummary
  ): zio.aws.iot.model.JobExecutionSummary.ReadOnly = new Wrapper(impl)
}
