package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class JobExecutionsRetryConfig(
    criteriaList: Iterable[zio.aws.iot.model.RetryCriteria]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.JobExecutionsRetryConfig = {
    import JobExecutionsRetryConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.JobExecutionsRetryConfig
      .builder()
      .criteriaList(criteriaList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.JobExecutionsRetryConfig.ReadOnly =
    zio.aws.iot.model.JobExecutionsRetryConfig.wrap(buildAwsValue())
}
object JobExecutionsRetryConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.JobExecutionsRetryConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.JobExecutionsRetryConfig =
      zio.aws.iot.model.JobExecutionsRetryConfig(criteriaList.map { item =>
        item.asEditable
      })
    def criteriaList: List[zio.aws.iot.model.RetryCriteria.ReadOnly]
    def getCriteriaList
        : ZIO[Any, Nothing, List[zio.aws.iot.model.RetryCriteria.ReadOnly]] =
      ZIO.succeed(criteriaList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.JobExecutionsRetryConfig
  ) extends zio.aws.iot.model.JobExecutionsRetryConfig.ReadOnly {
    override val criteriaList: List[zio.aws.iot.model.RetryCriteria.ReadOnly] =
      impl
        .criteriaList()
        .asScala
        .map { item =>
          zio.aws.iot.model.RetryCriteria.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.JobExecutionsRetryConfig
  ): zio.aws.iot.model.JobExecutionsRetryConfig.ReadOnly = new Wrapper(impl)
}
